/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.component;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.component.Component;
import org.mule.runtime.core.api.lifecycle.LifecycleCallback;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.lifecycle.SimpleLifecycleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentLifecycleManager
extends SimpleLifecycleManager<Component> {
    protected final transient Logger logger = LoggerFactory.getLogger(ComponentLifecycleManager.class);
    protected MuleContext muleContext;

    public ComponentLifecycleManager(String name, Component component) {
        super(name, component);
    }

    @Override
    public void fireInitialisePhase(LifecycleCallback<Component> callback) throws InitialisationException {
        this.checkPhase("initialise");
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Initialising component: " + this.lifecycleManagerId);
        }
        try {
            this.invokePhase("initialise", this.getLifecycleObject(), callback);
        }
        catch (InitialisationException e) {
            throw e;
        }
        catch (LifecycleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this.object);
        }
    }

    @Override
    public void fireStartPhase(LifecycleCallback<Component> callback) throws MuleException {
        this.checkPhase("start");
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Starting component: " + this.lifecycleManagerId);
        }
        this.invokePhase("start", this.getLifecycleObject(), callback);
    }

    @Override
    public void fireStopPhase(LifecycleCallback<Component> callback) throws MuleException {
        this.checkPhase("stop");
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Stopping component: " + this.lifecycleManagerId);
        }
        this.invokePhase("stop", this.getLifecycleObject(), callback);
    }

    @Override
    public void fireDisposePhase(LifecycleCallback<Component> callback) {
        this.checkPhase("dispose");
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Disposing component: " + this.lifecycleManagerId);
        }
        try {
            this.invokePhase("dispose", this.getLifecycleObject(), callback);
        }
        catch (LifecycleException e) {
            this.logger.warn(CoreMessages.failedToDispose(this.lifecycleManagerId).toString(), (Throwable)e);
        }
    }
}

