/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el.function;

import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.mule.runtime.core.api.el.ExpressionLanguageContext;
import org.mule.runtime.core.api.el.ExpressionLanguageFunction;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.core.el.context.MessageContext;

public class WildcardExpressionLanguageFuntion
implements ExpressionLanguageFunction {
    private static final boolean DEFAULT_SENSITIVITY = true;

    @Override
    public Object call(Object[] params, ExpressionLanguageContext context) {
        int numParams = params.length;
        if (numParams < 1 || numParams > 3) {
            throw new IllegalArgumentException("invalid number of arguments for the signature wildcard(wildcardExpression, [melExpression], [caseSensitive]) was expected");
        }
        String wildcardPattern = this.verifyWildcardPattern(params[0]);
        boolean result = false;
        if (numParams == 1) {
            try {
                result = this.isMatch(wildcardPattern, context.getVariable("message", MessageContext.class).payloadAs(String.class), true);
            }
            catch (TransformerException e) {
                throw new RuntimeException("Unable to convert payload to string");
            }
        } else {
            String text = this.verifyText(params[1]);
            if (numParams == 2) {
                result = this.isMatch(wildcardPattern, text, true);
            } else if (numParams == 3) {
                result = this.isMatch(wildcardPattern, text, (Boolean)params[2]);
            }
        }
        return result;
    }

    protected String verifyWildcardPattern(Object wildcardPattern) {
        if (wildcardPattern == null) {
            throw new IllegalArgumentException("wildcard pattern is null");
        }
        if (!(wildcardPattern instanceof String)) {
            throw new IllegalArgumentException("wildcard pattern is not a string");
        }
        if (StringUtils.isBlank((String)wildcardPattern)) {
            throw new IllegalArgumentException("wildcard pattern cannot be blank");
        }
        return (String)wildcardPattern;
    }

    protected String verifyText(Object text) {
        if (text == null) {
            throw new IllegalArgumentException("text is null");
        }
        if (!(text instanceof String)) {
            throw new IllegalArgumentException("text is not a string");
        }
        return (String)text;
    }

    protected boolean isMatch(String wildcardPattern, String text, boolean caseSensitive) {
        return FilenameUtils.wildcardMatch((String)text, (String)wildcardPattern, (IOCase)(caseSensitive ? IOCase.SENSITIVE : IOCase.INSENSITIVE));
    }
}

