/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.connection;

import java.util.Optional;
import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.retry.RetryPolicyTemplate;
import org.mule.runtime.core.internal.connection.ConnectionManagerAdapter;
import org.mule.runtime.core.internal.connection.ConnectionProviderWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifecycleAwareConnectionProviderWrapper<C>
extends ConnectionProviderWrapper<C> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LifecycleAwareConnectionProviderWrapper.class);
    private final MuleContext muleContext;
    private final ConnectionManagerAdapter connectionManager;

    public LifecycleAwareConnectionProviderWrapper(ConnectionProvider<C> delegate, MuleContext muleContext) {
        super(delegate);
        this.muleContext = muleContext;
        this.connectionManager = (ConnectionManagerAdapter)muleContext.getRegistry().get("_muleConnectionManager");
    }

    @Override
    public C connect() throws ConnectionException {
        Object connection = super.connect();
        try {
            this.muleContext.getInjector().inject(connection);
            this.muleContext.getRegistry().applyLifecycle(connection, "not in lifecycle", "start");
        }
        catch (MuleException e) {
            throw new ConnectionException("Could not initialise connection", (Throwable)e);
        }
        return connection;
    }

    @Override
    public void disconnect(C connection) {
        try {
            super.disconnect(connection);
        }
        finally {
            try {
                this.muleContext.getRegistry().applyLifecycle(connection, "start", "dispose");
            }
            catch (MuleException e) {
                LOGGER.warn("Exception was found trying to dispose connection", (Throwable)e);
            }
        }
    }

    @Override
    public RetryPolicyTemplate getRetryPolicyTemplate() {
        ConnectionProvider delegate = this.getDelegate();
        if (delegate instanceof ConnectionProviderWrapper) {
            return ((ConnectionProviderWrapper)delegate).getRetryPolicyTemplate();
        }
        return this.connectionManager.getDefaultRetryPolicyTemplate();
    }

    @Override
    public Optional<PoolingProfile> getPoolingProfile() {
        ConnectionProvider delegate = this.getDelegate();
        return delegate instanceof ConnectionProviderWrapper ? ((ConnectionProviderWrapper)delegate).getPoolingProfile() : Optional.empty();
    }
}

