/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.bytes;

import org.mule.runtime.core.internal.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.internal.streaming.bytes.factory.InMemoryCursorStreamProviderFactory;
import org.mule.runtime.core.internal.streaming.bytes.factory.NullCursorStreamProviderFactory;
import org.mule.runtime.core.streaming.StreamingManager;
import org.mule.runtime.core.streaming.bytes.ByteStreamingManager;
import org.mule.runtime.core.streaming.bytes.CursorStreamProviderFactory;
import org.mule.runtime.core.streaming.bytes.InMemoryCursorStreamConfig;

public class DefaultByteStreamingManager
implements ByteStreamingManager {
    private final ByteBufferManager bufferManager;
    protected final StreamingManager streamingManager;

    public DefaultByteStreamingManager(ByteBufferManager bufferManager, StreamingManager streamingManager) {
        this.bufferManager = bufferManager;
        this.streamingManager = streamingManager;
    }

    @Override
    public CursorStreamProviderFactory getInMemoryCursorProviderFactory(InMemoryCursorStreamConfig config) {
        return new InMemoryCursorStreamProviderFactory(this.bufferManager, config, this.streamingManager);
    }

    @Override
    public CursorStreamProviderFactory getNullCursorProviderFactory() {
        return new NullCursorStreamProviderFactory(this.bufferManager, this.streamingManager);
    }

    @Override
    public CursorStreamProviderFactory getDefaultCursorProviderFactory() {
        return new InMemoryCursorStreamProviderFactory(this.bufferManager, InMemoryCursorStreamConfig.getDefault(), this.streamingManager);
    }

    protected ByteBufferManager getBufferManager() {
        return this.bufferManager;
    }
}

