/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.simple;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import java.nio.charset.Charset;
import java.util.Map;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.DiscoverableTransformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.transformer.AbstractTransformer;

public class StringToBoolean
extends AbstractTransformer
implements DiscoverableTransformer {
    private static Map<String, Boolean> MAPPING = ImmutableMap.builder().put((Object)"true", (Object)Boolean.TRUE).put((Object)"false", (Object)Boolean.FALSE).put((Object)"yes", (Object)Boolean.TRUE).put((Object)"no", (Object)Boolean.FALSE).put((Object)"1", (Object)Boolean.TRUE).put((Object)"0", (Object)Boolean.FALSE).build();
    private int priorityWeighting = 2;

    public StringToBoolean() {
        this.registerSourceType(DataType.STRING);
        this.setReturnDataType(DataType.BOOLEAN);
    }

    @Override
    public Object doTransform(Object src, Charset encoding) throws TransformerException {
        if (src == null) {
            if (this.isAllowNullReturn()) {
                return null;
            }
            throw new TransformerException(I18nMessageFactory.createStaticMessage("Unable to transform null to a primitive"));
        }
        String value = ((String)src).toLowerCase().trim();
        Boolean transformed = MAPPING.get(value);
        if (transformed != null) {
            return transformed;
        }
        throw new TransformerException(I18nMessageFactory.createStaticMessage(String.format("Cannot transform String '%s' to boolean. Valid types are: [%s]", value, Joiner.on((String)", ").join(MAPPING.keySet()))));
    }

    @Override
    public void setReturnDataType(DataType type) {
        if (!Boolean.class.isAssignableFrom(type.getType())) {
            throw new IllegalArgumentException("This transformer only supports Boolean return types.");
        }
        super.setReturnDataType(type);
    }

    @Override
    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    @Override
    public void setPriorityWeighting(int priorityWeighting) {
        this.priorityWeighting = priorityWeighting;
    }
}

