/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.message;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import org.mule.runtime.core.message.BaseAttributes;

public class PartAttributes
extends BaseAttributes {
    private static final long serialVersionUID = -4718443205714605260L;
    private Map<String, LinkedList<String>> headers;
    private String name;
    private String fileName;
    private long size;

    public PartAttributes(String name, String fileName, long size, Map<String, LinkedList<String>> headers) {
        this.name = Objects.requireNonNull(name);
        this.fileName = fileName;
        this.size = size;
        this.headers = ImmutableMap.copyOf(headers);
    }

    public PartAttributes(String name) {
        this(name, null, -1L, Collections.emptyMap());
    }

    public String getName() {
        return this.name;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getSize() {
        return this.size;
    }

    public Map<String, LinkedList<String>> getHeaders() {
        return this.headers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartAttributes that = (PartAttributes)o;
        return this.size == that.size && Objects.equals(this.headers, that.headers) && Objects.equals(this.name, that.name) && Objects.equals(this.fileName, that.fileName);
    }

    public int hashCode() {
        return Objects.hash(this.headers, this.name, this.fileName, this.size);
    }
}

