/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.processor;

import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkListener;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncWorkListener
implements WorkListener {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Processor target;

    public AsyncWorkListener(Processor target) {
        this.target = target;
    }

    public void workAccepted(WorkEvent event) {
        this.handleWorkException(event, "workAccepted");
    }

    public void workRejected(WorkEvent event) {
        this.handleWorkException(event, "workRejected");
    }

    public void workStarted(WorkEvent event) {
        this.handleWorkException(event, "workStarted");
    }

    public void workCompleted(WorkEvent event) {
        this.handleWorkException(event, "workCompleted");
    }

    protected void handleWorkException(WorkEvent event, String type) {
        if (event == null) {
            return;
        }
        Object e = event.getException();
        if (e == null) {
            return;
        }
        if (e.getCause() != null) {
            e = e.getCause();
        }
        this.logger.error("Work caused exception on '" + type + "'. Work being executed was: " + event.getWork().toString());
        throw new MuleRuntimeException(CoreMessages.errorInvokingMessageProcessorAsynchronously(this.target), (Throwable)e);
    }
}

