/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.processor;

import javax.transaction.Transaction;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.transaction.TransactionFactory;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.transaction.AbstractTransaction;

public class DelegateTransaction
extends AbstractTransaction {
    private org.mule.runtime.core.api.transaction.Transaction delegate = new NullTransaction();

    public DelegateTransaction(MuleContext muleContext) {
        super(muleContext);
    }

    @Override
    protected void doBegin() throws TransactionException {
    }

    @Override
    protected void doCommit() throws TransactionException {
        this.delegate.commit();
    }

    @Override
    protected void doRollback() throws TransactionException {
        this.delegate.rollback();
    }

    @Override
    public int getStatus() throws TransactionException {
        return this.delegate.getStatus();
    }

    @Override
    public boolean isBegun() throws TransactionException {
        return this.delegate.isBegun();
    }

    @Override
    public boolean isRolledBack() throws TransactionException {
        return this.delegate.isRolledBack();
    }

    @Override
    public boolean isCommitted() throws TransactionException {
        return this.delegate.isCommitted();
    }

    @Override
    public Object getResource(Object key) {
        return this.delegate.getResource(key);
    }

    @Override
    public boolean hasResource(Object key) {
        return this.delegate.hasResource(key);
    }

    @Override
    public boolean supports(Object key, Object resource) {
        return this.delegate.supports(key, resource);
    }

    @Override
    public void bindResource(Object key, Object resource) throws TransactionException {
        if (!(this.delegate instanceof NullTransaction)) {
            throw new TransactionException(CoreMessages.createStaticMessage("Single resource transaction has already a resource bound"));
        }
        TransactionFactory transactionFactory = this.muleContext.getTransactionFactoryManager().getTransactionFactoryFor(key.getClass());
        this.unbindTransaction();
        int timeout = this.delegate.getTimeout();
        this.delegate = transactionFactory.beginTransaction(this.muleContext);
        this.delegate.setTimeout(timeout);
        this.delegate.bindResource(key, resource);
    }

    @Override
    public void setRollbackOnly() throws TransactionException {
        this.delegate.setRollbackOnly();
    }

    @Override
    public boolean isRollbackOnly() throws TransactionException {
        return this.delegate.isRollbackOnly();
    }

    @Override
    public boolean isXA() {
        return this.delegate.isXA();
    }

    @Override
    public void resume() throws TransactionException {
        this.delegate.resume();
    }

    @Override
    public Transaction suspend() throws TransactionException {
        return this.delegate.suspend();
    }

    @Override
    public String getId() {
        return this.delegate.getId();
    }

    public boolean supportsInnerTransaction(org.mule.runtime.core.api.transaction.Transaction transaction) {
        return this.delegate instanceof NullTransaction || this.delegate == transaction;
    }

    @Override
    public int getTimeout() {
        return this.delegate.getTimeout();
    }

    @Override
    public void setTimeout(int timeout) {
        this.delegate.setTimeout(timeout);
    }

    private class NullTransaction
    implements org.mule.runtime.core.api.transaction.Transaction {
        private int timeout;

        private NullTransaction() {
            this.timeout = DelegateTransaction.this.muleContext.getConfiguration().getDefaultTransactionTimeout();
        }

        @Override
        public void begin() throws TransactionException {
        }

        @Override
        public void commit() throws TransactionException {
        }

        @Override
        public void rollback() throws TransactionException {
        }

        @Override
        public int getStatus() throws TransactionException {
            return 5;
        }

        @Override
        public boolean isBegun() throws TransactionException {
            return false;
        }

        @Override
        public boolean isRolledBack() throws TransactionException {
            return false;
        }

        @Override
        public boolean isCommitted() throws TransactionException {
            return false;
        }

        @Override
        public int getTimeout() {
            return this.timeout;
        }

        @Override
        public void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        @Override
        public Object getResource(Object key) {
            return null;
        }

        @Override
        public boolean hasResource(Object key) {
            return false;
        }

        @Override
        public boolean supports(Object key, Object resource) {
            return true;
        }

        @Override
        public void bindResource(Object key, Object resource) throws TransactionException {
        }

        @Override
        public void setRollbackOnly() throws TransactionException {
        }

        @Override
        public boolean isRollbackOnly() throws TransactionException {
            return false;
        }

        @Override
        public boolean isXA() {
            return false;
        }

        @Override
        public void resume() throws TransactionException {
        }

        @Override
        public Transaction suspend() throws TransactionException {
            return null;
        }

        @Override
        public String getId() {
            return null;
        }
    }
}

