/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.processor.interceptor;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.mule.runtime.api.interception.InterceptionAction;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.interception.DefaultInterceptionEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.processor.interceptor.InterceptionException;
import reactor.core.publisher.Mono;

class ReactiveInterceptionAction
implements InterceptionAction {
    private MuleContext muleContext;
    private Processor processor;
    private ReactiveProcessor next;
    private DefaultInterceptionEvent interceptionEvent;

    public ReactiveInterceptionAction(DefaultInterceptionEvent interceptionEvent, ReactiveProcessor next, Processor processor, MuleContext muleContext) {
        this.interceptionEvent = interceptionEvent;
        this.next = next;
        this.processor = processor;
        this.muleContext = muleContext;
    }

    @Override
    public CompletableFuture<InterceptionEvent> proceed() {
        return Mono.just((Object)this.interceptionEvent.resolve()).transform((Function)this.next).map(event -> new DefaultInterceptionEvent((Event)event)).cast(InterceptionEvent.class).toFuture();
    }

    @Override
    public CompletableFuture<InterceptionEvent> skip() {
        this.interceptionEvent.resolve();
        return CompletableFuture.completedFuture(this.interceptionEvent);
    }

    @Override
    public CompletableFuture<InterceptionEvent> fail(Throwable cause) {
        Error newError = ExceptionUtils.getErrorFromFailingProcessor(this.processor, cause, this.muleContext.getErrorTypeLocator());
        this.interceptionEvent.setError(newError.getErrorType(), cause);
        CompletableFuture<InterceptionEvent> completableFuture = new CompletableFuture<InterceptionEvent>();
        completableFuture.completeExceptionally(new MessagingException(this.interceptionEvent.resolve(), cause, this.processor));
        return completableFuture;
    }

    @Override
    public CompletableFuture<InterceptionEvent> fail(ErrorType errorType) {
        InterceptionException cause = new InterceptionException("");
        this.interceptionEvent.setError(errorType, cause);
        CompletableFuture<InterceptionEvent> completableFuture = new CompletableFuture<InterceptionEvent>();
        completableFuture.completeExceptionally(new MessagingException(this.interceptionEvent.resolve(), cause, this.processor));
        return completableFuture;
    }
}

