/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.registry.map;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.mule.runtime.api.lifecycle.Disposable;
import org.slf4j.Logger;

public class RegistryMap {
    private final Map<String, Object> registry = new HashMap<String, Object>();
    private final ReadWriteLock registryLock = new ReentrantReadWriteLock();
    private final Set<Object> lostObjects = new TreeSet<Object>(new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            return o1 == o2 ? 0 : this.nvl(o1) - this.nvl(o2);
        }

        private int nvl(Object o) {
            return o != null ? o.hashCode() : 0;
        }
    });
    private Logger logger;

    public RegistryMap(Logger log) {
        this.logger = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<?> select(Predicate predicate) {
        Lock readLock = this.registryLock.readLock();
        try {
            readLock.lock();
            Collection collection = CollectionUtils.select(this.registry.values(), (Predicate)predicate);
            return collection;
        }
        finally {
            readLock.unlock();
        }
    }

    public void clear() {
        Lock writeLock = this.registryLock.writeLock();
        try {
            writeLock.lock();
            this.registry.clear();
            this.lostObjects.clear();
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAndLogWarningIfDuplicate(String key, Object object) {
        Lock writeLock = this.registryLock.writeLock();
        try {
            writeLock.lock();
            Object previousObject = this.registry.put(key, object);
            if (previousObject != null && previousObject != object) {
                if (previousObject instanceof Disposable) {
                    this.lostObjects.add(previousObject);
                }
                this.logger.warn("TransientRegistry already contains an object named '" + key + "'.  The previous object will be overwritten.");
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    public void putAll(Map<String, Object> map) {
        Lock writeLock = this.registryLock.writeLock();
        try {
            writeLock.lock();
            this.registry.putAll(map);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(String key) {
        Lock readLock = this.registryLock.readLock();
        try {
            readLock.lock();
            Object object = this.registry.get(key);
            return (T)object;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(String key) {
        Lock writeLock = this.registryLock.writeLock();
        try {
            writeLock.lock();
            Object object = this.registry.remove(key);
            return object;
        }
        finally {
            writeLock.unlock();
        }
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this.registry.entrySet();
    }

    public Set<Object> getLostObjects() {
        return this.lostObjects;
    }

    public void lockForReading() {
        this.registryLock.readLock().lock();
    }

    public void unlockForReading() {
        this.registryLock.readLock().unlock();
    }
}

