/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.routing;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.connector.DispatchException;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.routing.RoutingException;
import org.mule.runtime.core.api.util.StringMessageUtils;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.routing.RoutingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRoutingStrategy
implements RoutingStrategy {
    protected static transient Logger logger = LoggerFactory.getLogger(AbstractRoutingStrategy.class);
    private final MuleContext muleContext;

    public AbstractRoutingStrategy(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    protected final Event sendRequest(Event routedEvent, Message message, Processor route, boolean awaitResponse) throws MuleException {
        Event result;
        try {
            result = this.sendRequestEvent(routedEvent, message, route, awaitResponse);
        }
        catch (MuleException me) {
            throw me;
        }
        catch (Exception e) {
            throw new RoutingException(null, (Throwable)e);
        }
        if (result != null) {
            Message resultMessage = result.getMessage();
            if (logger.isTraceEnabled() && resultMessage != null) {
                try {
                    logger.trace("Response payload: \n" + StringMessageUtils.truncate(this.muleContext.getTransformationService().getPayloadForLogging(resultMessage), 100, false));
                }
                catch (Exception e) {
                    logger.trace("Response payload: \n(unable to retrieve payload: " + e.getMessage());
                }
            }
        }
        return result;
    }

    private Event sendRequestEvent(Event routedEvent, Message message, Processor route, boolean awaitResponse) throws MuleException {
        if (route == null) {
            throw new DispatchException(CoreMessages.objectIsNull("route"), null);
        }
        return route.process(this.createEventToRoute(routedEvent, message, route));
    }

    protected Event createEventToRoute(Event routedEvent, Message message, Processor route) {
        return Event.builder(routedEvent).message(message).build();
    }

    protected MuleContext getMuleContext() {
        return this.muleContext;
    }

    public static void validateMessageIsNotConsumable(Event event, Message message) throws MuleException {
        if (message.getPayload().getDataType().isStreamType()) {
            throw new DefaultMuleException(CoreMessages.cannotCopyStreamPayload(message.getPayload().getDataType().getType().getName()));
        }
    }
}

