/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transaction;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.tx.MuleXaObject;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.transaction.AbstractTransaction;
import org.mule.runtime.core.transaction.IllegalTransactionStateException;
import org.mule.runtime.core.transaction.TransactionRollbackException;
import org.mule.runtime.core.transaction.TransactionStatusException;
import org.mule.runtime.core.util.xa.XaResourceFactoryHolder;

public class XaTransaction
extends AbstractTransaction {
    protected Transaction transaction = null;
    private Map<ResourceKey, Object> resources = new HashMap<ResourceKey, Object>();
    protected TransactionManager txManager;

    public XaTransaction(MuleContext context) {
        super(context);
        this.txManager = context.getTransactionManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doBegin() throws TransactionException {
        if (this.txManager == null) {
            throw new IllegalStateException(CoreMessages.objectNotRegistered("javax.transaction.TransactionManager", "Transaction Manager").getMessage());
        }
        try {
            this.txManager.setTransactionTimeout(this.getTimeoutInSeconds());
            this.txManager.begin();
            XaTransaction xaTransaction = this;
            synchronized (xaTransaction) {
                this.transaction = this.txManager.getTransaction();
            }
        }
        catch (Exception e) {
            throw new TransactionException(CoreMessages.cannotStartTransaction("XA"), (Throwable)e);
        }
    }

    @Override
    protected synchronized void doCommit() throws TransactionException {
        try {
            this.delistResources();
            this.txManager.commit();
        }
        catch (RollbackException e) {
            throw new TransactionRollbackException(CoreMessages.transactionMarkedForRollback(), (Throwable)e);
        }
        catch (HeuristicRollbackException e) {
            throw new TransactionRollbackException(CoreMessages.transactionMarkedForRollback(), (Throwable)e);
        }
        catch (Exception e) {
            throw new IllegalTransactionStateException(CoreMessages.transactionCommitFailed(), (Throwable)e);
        }
        finally {
            this.transaction = null;
            this.closeResources();
        }
    }

    @Override
    protected void doRollback() throws TransactionRollbackException {
        try {
            this.txManager.rollback();
        }
        catch (SystemException e) {
            throw new TransactionRollbackException(e);
        }
        catch (Exception e) {
            throw new TransactionRollbackException(e);
        }
        finally {
            this.transaction = null;
            this.closeResources();
        }
    }

    @Override
    public synchronized int getStatus() throws TransactionStatusException {
        if (this.transaction == null) {
            return 6;
        }
        try {
            return this.transaction.getStatus();
        }
        catch (SystemException e) {
            throw new TransactionStatusException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRollbackOnly() {
        if (this.transaction == null) {
            throw new IllegalStateException("Current thread is not associated with a transaction.");
        }
        try {
            XaTransaction xaTransaction = this;
            synchronized (xaTransaction) {
                this.transaction.setRollbackOnly();
            }
        }
        catch (SystemException e) {
            throw (IllegalStateException)new IllegalStateException("Failed to set transaction to rollback only: " + e.getMessage()).initCause(e);
        }
    }

    @Override
    public synchronized Object getResource(Object key) {
        ResourceKey normalizedKey = this.getResourceEntry(key);
        return this.resources.get(normalizedKey);
    }

    @Override
    public synchronized boolean hasResource(Object key) {
        ResourceKey normalizedKey = this.getResourceEntry(key);
        return this.resources.containsKey(normalizedKey);
    }

    @Override
    public synchronized void bindResource(Object key, Object resource) throws TransactionException {
        ResourceKey normalizedKey = this.getResourceEntry(key, resource);
        if (this.resources.containsKey(key)) {
            throw new IllegalTransactionStateException(CoreMessages.transactionResourceAlreadyListedForKey(key));
        }
        this.resources.put(normalizedKey, resource);
        if (key == null) {
            this.logger.error("Key for bound resource " + resource + " is null");
        }
        if (resource instanceof MuleXaObject) {
            MuleXaObject xaObject = (MuleXaObject)resource;
            xaObject.enlist();
        } else if (resource instanceof XAResource) {
            this.enlistResource((XAResource)resource);
        } else {
            this.logger.error("Bound resource " + resource + " is neither a MuleXaObject nor XAResource");
        }
    }

    public boolean enlistResource(XAResource resource) throws TransactionException {
        TransactionManager txManager = this.muleContext.getTransactionManager();
        try {
            Transaction jtaTransaction = txManager.getTransaction();
            if (jtaTransaction == null) {
                throw new TransactionException(I18nMessageFactory.createStaticMessage("XATransaction is null"));
            }
            resource.setTransactionTimeout(this.getTimeoutInSeconds());
            return jtaTransaction.enlistResource(resource);
        }
        catch (RollbackException e) {
            throw new TransactionException(e);
        }
        catch (SystemException e) {
            throw new TransactionException(e);
        }
        catch (XAException e) {
            throw new TransactionException(e);
        }
    }

    private int getTimeoutInSeconds() {
        return this.getTimeout() / 1000;
    }

    public boolean delistResource(XAResource resource, int tmflag) throws TransactionException {
        TransactionManager txManager = this.muleContext.getTransactionManager();
        try {
            Transaction jtaTransaction = txManager.getTransaction();
            if (jtaTransaction == null) {
                throw new TransactionException(CoreMessages.noJtaTransactionAvailable(Thread.currentThread()));
            }
            return jtaTransaction.delistResource(resource, tmflag);
        }
        catch (SystemException e) {
            throw new TransactionException(e);
        }
    }

    @Override
    public String toString() {
        return this.transaction == null ? " <n/a>" : this.transaction.toString();
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    @Override
    public boolean isXA() {
        return true;
    }

    @Override
    public void resume() throws TransactionException {
        TransactionManager txManager = this.muleContext.getTransactionManager();
        if (txManager == null) {
            throw new IllegalStateException(CoreMessages.objectNotRegistered("javax.transaction.TransactionManager", "Transaction Manager").getMessage());
        }
        try {
            txManager.resume(this.transaction);
        }
        catch (InvalidTransactionException e) {
            throw new TransactionException(e);
        }
        catch (SystemException e) {
            throw new TransactionException(e);
        }
    }

    @Override
    public Transaction suspend() throws TransactionException {
        TransactionManager txManager = this.muleContext.getTransactionManager();
        if (txManager == null) {
            throw new IllegalStateException(CoreMessages.objectNotRegistered("javax.transaction.TransactionManager", "Transaction Manager").getMessage());
        }
        try {
            this.transaction = txManager.suspend();
        }
        catch (SystemException e) {
            throw new TransactionException(e);
        }
        return this.transaction;
    }

    protected void delistResources() {
        for (Map.Entry<ResourceKey, Object> entry : this.resources.entrySet()) {
            Object xaObject = entry.getValue();
            if (!(xaObject instanceof MuleXaObject)) continue;
            try {
                ((MuleXaObject)xaObject).delist();
            }
            catch (Exception e) {
                this.logger.error("Failed to delist resource " + xaObject, (Throwable)e);
            }
        }
    }

    protected void closeResources() {
        Iterator<Map.Entry<ResourceKey, Object>> i = this.resources.entrySet().iterator();
        while (i.hasNext()) {
            MuleXaObject xaObject;
            Map.Entry<ResourceKey, Object> entry = i.next();
            Object value = entry.getValue();
            if (!(value instanceof MuleXaObject) || (xaObject = (MuleXaObject)value).isReuseObject()) continue;
            try {
                xaObject.close();
                i.remove();
            }
            catch (Exception e) {
                this.logger.error("Failed to close resource " + xaObject, (Throwable)e);
            }
        }
    }

    @Override
    public boolean supports(Object key, Object resource) {
        return resource instanceof XAResource || resource instanceof MuleXaObject;
    }

    private ResourceKey getResourceEntry(Object resourceFactory) {
        resourceFactory = resourceFactory instanceof XaResourceFactoryHolder ? ((XaResourceFactoryHolder)resourceFactory).getHoldObject() : resourceFactory;
        return new ResourceKey(resourceFactory, null);
    }

    private ResourceKey getResourceEntry(Object resourceFactory, Object resource) {
        resourceFactory = resourceFactory instanceof XaResourceFactoryHolder ? ((XaResourceFactoryHolder)resourceFactory).getHoldObject() : resourceFactory;
        return new ResourceKey(resourceFactory, resource);
    }

    private static class ResourceKey {
        private Object resourceFactory;
        private Object resource;

        public ResourceKey(Object resourceFactory) {
            Preconditions.checkArgument(resourceFactory != null, "resourceFactory cannot be null");
            this.resourceFactory = resourceFactory;
            this.resource = null;
        }

        public ResourceKey(Object resourceFactory, Object resource) {
            this(resourceFactory);
            this.resource = resource;
        }

        public Object getResourceFactory() {
            return this.resourceFactory;
        }

        public Object getResource() {
            return this.resource;
        }

        public int hashCode() {
            return System.identityHashCode(this.resourceFactory);
        }

        public boolean equals(Object obj) {
            return this.resourceFactory.equals(((ResourceKey)obj).getResourceFactory());
        }
    }
}

