/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.transformer.simple;

import java.nio.charset.Charset;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.transformer.AbstractMessageTransformer;

public class ParseTemplateTransformer
extends AbstractMessageTransformer {
    private String location;
    private String template;

    public ParseTemplateTransformer() {
        this.registerSourceType(DataType.OBJECT);
        this.setReturnDataType(DataType.OBJECT);
    }

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        this.loadTemplate();
    }

    private void loadTemplate() throws InitialisationException {
        try {
            if (this.location == null) {
                throw new IllegalArgumentException("Location cannot be null");
            }
            this.template = IOUtils.getResourceAsString(this.location, this.getClass());
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    @Override
    public Object transformMessage(Event event, Charset outputEncoding) throws TransformerException {
        if (this.template == null) {
            throw new IllegalArgumentException("Template cannot be null");
        }
        return this.muleContext.getExpressionManager().parse(this.template, event, null);
    }

    public void setLocation(String location) {
        this.location = location;
    }
}

