/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.declaration.type;

import java.lang.reflect.Type;
import java.util.List;
import org.mule.metadata.api.annotation.TypeAliasAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.UnionTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.java.api.handler.ClassHandler;
import org.mule.metadata.java.api.handler.TypeHandlerManager;
import org.mule.metadata.java.api.utils.ParsingContext;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.extension.api.declaration.type.InfrastructureTypeBuilder;
import org.mule.runtime.extension.api.declaration.type.annotation.InfrastructureTypeAnnotation;

final class TlsContextClassHandler
extends InfrastructureTypeBuilder
implements ClassHandler {
    TlsContextClassHandler() {
    }

    @Override
    public boolean handles(Class<?> clazz) {
        return TlsContextFactory.class.equals(clazz);
    }

    @Override
    public TypeBuilder<?> handleClass(Class<?> clazz, List<Type> genericTypes, TypeHandlerManager typeHandlerManager, ParsingContext context, BaseTypeBuilder typeBuilder) {
        ObjectTypeBuilder type = this.objectType(typeBuilder, TlsContextFactory.class, context);
        typeBuilder = BaseTypeBuilder.create(MetadataFormat.JAVA);
        type.with(new TypeAliasAnnotation("Tls"));
        type.with(new InfrastructureTypeAnnotation());
        this.addStringField(type, typeBuilder, "enabledProtocols", "A comma separated list of protocols enabled for this context.", null);
        this.addStringField(type, typeBuilder, "enabledCipherSuites", "A comma separated list of cipher suites enabled for this context.", null);
        this.addTrustStoreField(typeBuilder, type);
        this.addKeyStoreField(typeBuilder, type);
        return type;
    }

    private void addTrustStoreField(BaseTypeBuilder typeBuilder, ObjectTypeBuilder type) {
        ObjectTypeBuilder trustStoreType = typeBuilder.objectType().id(Object.class.getName()).with(new InfrastructureTypeAnnotation()).with(new TypeAliasAnnotation("TrustStore")).description("Trust store configuration. If used client side, the trust store contains the certificates of the trusted servers. If used server side, it contains the certificates of the trusted clients.");
        typeBuilder = BaseTypeBuilder.create(MetadataFormat.JAVA);
        this.addStringField(trustStoreType, typeBuilder, "path", "The location (which will be resolved relative to the current classpath and file system, if possible) of the trust store.", null);
        this.addPasswordField(trustStoreType, typeBuilder, "password", "The password used to protect the trust store.", null);
        this.addField(trustStoreType, this.getStoreMetadataType(typeBuilder), "type", "The type of store used.");
        this.addStringField(trustStoreType, typeBuilder, "algorithm", "The algorithm used by the trust store.", null);
        this.addBooleanField(trustStoreType, typeBuilder, "insecure", "If true, no certificate validations will be performed, rendering connections vulnerable to attacks. Use at your own risk.", false);
        type.addField().key("trust-store").required(false).value(trustStoreType);
    }

    private UnionTypeBuilder getStoreMetadataType(BaseTypeBuilder typeBuilder) {
        return typeBuilder.unionType().of(this.getEnumType(BaseTypeBuilder.create(MetadataFormat.JAVA), null, "jks", "jceks", "pkcs12")).of(BaseTypeBuilder.create(MetadataFormat.JAVA).stringType());
    }

    private void addKeyStoreField(BaseTypeBuilder typeBuilder, ObjectTypeBuilder type) {
        ObjectTypeBuilder keyStoreType = typeBuilder.objectType().id(Object.class.getName()).with(new TypeAliasAnnotation("KeyStore")).with(new InfrastructureTypeAnnotation()).description("Key store configuration. The key store contains the keys of this server/client.");
        this.addStringField(keyStoreType, typeBuilder, "path", "The location (which will be resolved relative to the current classpath and file system, if possible) of the key store.", null);
        this.addField(keyStoreType, this.getStoreMetadataType(typeBuilder), "type", "The type of store used.");
        this.addStringField(keyStoreType, typeBuilder, "alias", "When the key store contains many private keys, this attribute indicates the alias of the key that should be used. If not defined, the first key in the file will be used by default.", null);
        this.addPasswordField(keyStoreType, typeBuilder, "keyPassword", "The password used to protect the private key.", null);
        this.addPasswordField(keyStoreType, typeBuilder, "password", "The password used to protect the key store.", null);
        this.addStringField(keyStoreType, typeBuilder, "algorithm", "The algorithm used by the key store.", null);
        type.addField().key("key-store").required(false).value(keyStoreType);
    }
}

