/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.extension.api.declaration.type.TypeUtils;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public final class ExportedTypesModelValidator
implements ExtensionModelValidator {
    @Override
    public void validate(ExtensionModel extensionModel, final ProblemsReporter problems) {
        new IdempotentExtensionWalker(){

            @Override
            public void onOperation(OperationModel model) {
                model.getAllParameterModels().stream().forEach(parameterModel -> ExportedTypesModelValidator.this.validateJavaType(model, parameterModel.getType(), problems));
                ExportedTypesModelValidator.this.validateJavaType(model, model.getOutput().getType(), problems);
            }

            @Override
            public void onSource(SourceModel model) {
                ExportedTypesModelValidator.this.validateJavaType(model, model.getOutput().getType(), problems);
            }
        }.walk(extensionModel);
    }

    private void validateJavaType(ComponentModel model, MetadataType type, ProblemsReporter problems) {
        if (type.getMetadataFormat().equals(MetadataFormat.JAVA)) {
            this.validateParameterFieldsHaveGetters(model, type, problems);
        }
    }

    private void validateParameterFieldsHaveGetters(final ComponentModel model, MetadataType parameterMetadataType, final ProblemsReporter problems) {
        if (!parameterMetadataType.getMetadataFormat().equals(MetadataFormat.JAVA)) {
            return;
        }
        final String componentTypeName = NameUtils.getComponentModelTypeName(model);
        final Class parameterType = JavaTypeUtils.getType(parameterMetadataType);
        parameterMetadataType.accept(new MetadataTypeVisitor(){

            @Override
            public void visitObject(ObjectType objectType) {
                Collection<ObjectFieldType> parameters = objectType.getFields();
                Set fieldsWithGetters = IntrospectionUtils.getFieldsWithGetters(parameterType).stream().map(TypeUtils::getAlias).map(String::toLowerCase).collect(Collectors.toSet());
                Set parameterWithoutGetters = parameters.stream().map(f -> f.getKey().getName().getLocalPart()).filter(fieldName -> !fieldsWithGetters.contains(fieldName.toLowerCase())).collect(Collectors.toSet());
                if (!parameterWithoutGetters.isEmpty()) {
                    problems.addError(new Problem(model, String.format("%s '%s' has an argument or return type of type '%s' which contains fields (%s) that doesn't have the corresponding getter methods or getter methods that doesn't correspond to any of the present fields", componentTypeName, model.getName(), parameterType.getName(), parameterWithoutGetters.stream().collect(Collectors.joining(", ")))));
                }
            }
        });
    }
}

