/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.security;

import java.util.List;
import org.mule.runtime.api.security.Authentication;
import org.mule.runtime.api.security.Credentials;
import org.mule.runtime.api.security.CredentialsBuilder;
import org.mule.runtime.api.security.SecurityException;
import org.mule.runtime.api.security.SecurityProviderNotFoundException;
import org.mule.runtime.api.security.UnknownAuthenticationTypeException;
import org.mule.runtime.core.api.MuleSession;
import org.mule.runtime.core.api.security.DefaultMuleAuthentication;
import org.mule.runtime.core.api.security.SecurityContext;
import org.mule.runtime.core.api.security.SecurityManager;
import org.mule.runtime.core.api.security.SecurityProvider;
import org.mule.runtime.core.security.DefaultMuleSecurityManager;
import org.mule.runtime.extension.api.security.AuthenticationHandler;
import org.mule.runtime.module.extension.internal.runtime.security.DefaultCredentialsBuilder;

public class DefaultAuthenticationHandler
implements AuthenticationHandler {
    private final MuleSession session;
    private SecurityManager manager;

    public DefaultAuthenticationHandler(SecurityManager manager, MuleSession session) {
        this.session = session;
        this.manager = manager;
    }

    @Override
    public void setAuthentication(Authentication authentication) throws SecurityProviderNotFoundException, SecurityException, UnknownAuthenticationTypeException {
        Authentication authResult = this.manager.authenticate(authentication);
        SecurityContext context = this.manager.createSecurityContext(authResult);
        context.setAuthentication(authResult);
        this.session.setSecurityContext(context);
    }

    @Override
    public void setAuthentication(List<String> securityProviders, Authentication authentication) throws SecurityProviderNotFoundException, SecurityException, UnknownAuthenticationTypeException {
        if (!securityProviders.isEmpty()) {
            DefaultMuleSecurityManager localManager = new DefaultMuleSecurityManager();
            for (String sp2 : securityProviders) {
                SecurityProvider provider = this.manager.getProvider(sp2);
                if (provider != null) {
                    localManager.addProvider(provider);
                    continue;
                }
                throw new SecurityProviderNotFoundException(sp2);
            }
            this.manager = localManager;
        }
        this.setAuthentication(authentication);
    }

    @Override
    public Authentication getAuthentication() {
        return this.session.getSecurityContext().getAuthentication();
    }

    @Override
    public Authentication createAuthentication(Credentials credentials) {
        return new DefaultMuleAuthentication(credentials);
    }

    @Override
    public CredentialsBuilder createCredentialsBuilder() {
        return new DefaultCredentialsBuilder();
    }
}

