/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QualifiedNameValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.ValidationErrorValue;

public final class NotationValue
extends QualifiedNameValue {
    public NotationValue(String string, String string2, String string3, NameChecker nameChecker) throws XPathException {
        if (nameChecker != null && !nameChecker.isValidNCName(string3)) {
            DynamicError dynamicError = new DynamicError("Malformed local name in NOTATION: '" + string3 + '\'');
            dynamicError.setErrorCode("FORG0001");
            throw dynamicError;
        }
        this.prefix = string == null ? "" : string;
        String string4 = this.uri = string2 == null ? "" : string2;
        if (nameChecker != null && this.uri.equals("") && !this.prefix.equals("")) {
            DynamicError dynamicError = new DynamicError("NOTATION has null namespace but non-empty prefix");
            dynamicError.setErrorCode("FOCA0002");
            throw dynamicError;
        }
        this.localPart = string3;
        this.typeLabel = BuiltInAtomicType.NOTATION;
    }

    public NotationValue(String string, String string2, String string3) {
        this.prefix = string;
        this.uri = string2;
        this.localPart = string3;
        this.typeLabel = BuiltInAtomicType.NOTATION;
    }

    public NotationValue(String string, String string2, String string3, AtomicType atomicType) {
        this.prefix = string;
        this.uri = string2;
        this.localPart = string3;
        this.typeLabel = atomicType;
    }

    public AtomicValue copy(AtomicType atomicType) {
        NotationValue notationValue = new NotationValue(this.getPrefix(), this.getNamespaceURI(), this.getLocalName());
        notationValue.typeLabel = atomicType;
        return notationValue;
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.NOTATION;
    }

    public AtomicValue convertPrimitive(BuiltInAtomicType builtInAtomicType, boolean bl, XPathContext xPathContext) {
        switch (builtInAtomicType.getPrimitiveType()) {
            case 88: 
            case 531: 
            case 632: {
                return this;
            }
            case 513: {
                return new StringValue(this.getStringValue());
            }
            case 631: {
                return new UntypedAtomicValue(this.getStringValue());
            }
        }
        ValidationException validationException = new ValidationException("Cannot convert NOTATION to " + builtInAtomicType.getDisplayName());
        validationException.setErrorCode("XPTY0004");
        validationException.setIsTypeError(true);
        return new ValidationErrorValue(validationException);
    }

    public boolean equals(Object object) {
        NotationValue notationValue = (NotationValue)object;
        return this.localPart.equals(notationValue.localPart) && (this.uri == notationValue.uri || this.uri != null && this.uri.equals(notationValue.uri));
    }

    public String toString() {
        return "NOTATION(" + this.getClarkName() + ')';
    }
}

