/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.util.HashMap;
import java.util.Map;

public class HttpThrottlingHeadersMapBuilder {
    private Long remainingRequestInCurrentPeriod;
    private Long maximumRequestAllowedPerPeriod;
    private Long timeUntilNextPeriodInMillis;

    public void setThrottlingPolicyStatistics(long remainingRequestInCurrentPeriod, long maximumRequestAllowedPerPeriod, long timeUntilNextPeriodInMillis) {
        this.remainingRequestInCurrentPeriod = remainingRequestInCurrentPeriod;
        this.maximumRequestAllowedPerPeriod = maximumRequestAllowedPerPeriod;
        this.timeUntilNextPeriodInMillis = timeUntilNextPeriodInMillis;
    }

    public Map<String, String> build() {
        HashMap<String, String> throttlingHeaders = new HashMap<String, String>();
        this.addToMapIfNotNull(throttlingHeaders, "X-RateLimit-Limit", this.maximumRequestAllowedPerPeriod);
        this.addToMapIfNotNull(throttlingHeaders, "X-RateLimit-Remaining", this.remainingRequestInCurrentPeriod);
        this.addToMapIfNotNull(throttlingHeaders, "X-RateLimit-Reset", this.timeUntilNextPeriodInMillis);
        return throttlingHeaders;
    }

    private void addToMapIfNotNull(Map<String, String> map, String key, Long value) {
        if (value != null) {
            map.put(key, String.valueOf(value));
        }
    }
}

