/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import org.junit.Assert;
import org.junit.Test;
import org.mule.config.MuleManifest;
import org.mule.tck.size.SmallTest;

@SmallTest
public class MuleManifestTestCase {
    @Test
    public void getCoreManifest() throws Exception {
        MuleManifest.UrlPrivilegedAction action = new MuleManifest.UrlPrivilegedAction();
        URL url = action.getManifestJarURL(this.getUrlsEnum("mule-bas-3.jar", "mule-core-3.jar", "mule-foo-3.jar"));
        Assert.assertTrue((boolean)url.toExternalForm().contains("mule-core-3.jar"));
    }

    @Test
    public void getCoreEeManifest() throws Exception {
        MuleManifest.UrlPrivilegedAction action = new MuleManifest.UrlPrivilegedAction();
        URL url = action.getManifestJarURL(this.getUrlsEnum("mule-bas-3.jar", "mule-core-3.jar", "mule-core-ee-3.jar", "mule-foo-3.jar"));
        Assert.assertTrue((boolean)url.toExternalForm().contains("mule-core-ee-3.jar"));
    }

    @Test
    public void getEmbeddedManifest() throws Exception {
        MuleManifest.UrlPrivilegedAction action = new MuleManifest.UrlPrivilegedAction();
        URL url = action.getManifestJarURL(this.getUrlsEnum("mule-bas-3.jar", "mule-3-embedded.jar", "mule-foo-3.jar"));
        Assert.assertTrue((boolean)url.toExternalForm().contains("mule-3-embedded.jar"));
    }

    private Enumeration<URL> getUrlsEnum(String ... names) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String name : names) {
            urls.add(new URL("file://" + name));
        }
        return Collections.enumeration(urls);
    }
}

