/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.bootstrap;

import java.util.ArrayList;
import java.util.Properties;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transaction.TransactionFactory;
import org.mule.config.bootstrap.FakeTransactionFactory;
import org.mule.config.bootstrap.FakeTransactionResource;
import org.mule.config.bootstrap.RegistryBootstrapDiscoverer;
import org.mule.config.bootstrap.SimpleRegistryBootstrap;
import org.mule.config.bootstrap.SinglePropertiesRegistryBootstrapDiscoverer;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class SimpleRegistryBootstrapTestCase
extends AbstractMuleContextTestCase {
    public static final String TEST_TRANSACTION_FACTORY_CLASS = "javax.jms.Connection";

    @Test(expected=ClassNotFoundException.class)
    public void registeringOptionalTransaction() throws Exception {
        this.createTestRegistryBootstrap();
        muleContext.getTransactionFactoryManager().getTransactionFactoryFor(Class.forName(TEST_TRANSACTION_FACTORY_CLASS));
    }

    @Test
    public void existingNotOptionalTransaction() throws Exception {
        this.createTestRegistryBootstrap();
        TransactionFactory transactionFactoryFor = muleContext.getTransactionFactoryManager().getTransactionFactoryFor(FakeTransactionResource.class);
        Assert.assertNotNull((Object)transactionFactoryFor);
    }

    @Test
    public void registerObjects() throws Exception {
        this.createTestRegistryBootstrap();
        Assert.assertThat((Object)muleContext.getRegistry().lookupObject(String.class), (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)muleContext.getRegistry().lookupObject(Properties.class), (Matcher)IsNull.nullValue());
        Assert.assertThat((Object)muleContext.getRegistry().lookupObject(ArrayList.class), (Matcher)IsNull.notNullValue());
    }

    private SimpleRegistryBootstrap createTestRegistryBootstrap() throws InitialisationException {
        Properties properties = new Properties();
        properties.put("1", "java.lang.String");
        properties.put("3", "java.util.ArrayList");
        properties.put("jms.singletx.transaction.resource1", String.format("%s,optional)", TEST_TRANSACTION_FACTORY_CLASS));
        properties.put("test.singletx.transaction.factory1", FakeTransactionFactory.class.getName());
        properties.put("test.singletx.transaction.resource1", FakeTransactionResource.class.getName());
        SimpleRegistryBootstrap simpleRegistryBootstrap = new SimpleRegistryBootstrap((RegistryBootstrapDiscoverer)new SinglePropertiesRegistryBootstrapDiscoverer(properties));
        simpleRegistryBootstrap.setMuleContext(muleContext);
        simpleRegistryBootstrap.initialise();
        return simpleRegistryBootstrap;
    }
}

