/*
 * Decompiled with CFR 0.152.
 */
package org.mule.context;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.verification.VerificationMode;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.exception.SystemExceptionHandler;
import org.mule.api.registry.ServiceType;
import org.mule.config.ExceptionHelper;
import org.mule.context.DefaultMuleContextFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class DefaultMuleContextTestCase
extends AbstractMuleTestCase {
    public static final String INITIAL_VALUE = "500";
    public static final String VALUE_AFTER_REDEPLOY = "222";
    public static final String TEST_PROTOCOL = "test2";
    private SystemExceptionHandler mockSystemExceptionHandler = (SystemExceptionHandler)Mockito.mock(SystemExceptionHandler.class);
    private MessagingException mockMessagingException = (MessagingException)((Object)Mockito.mock(MessagingException.class));

    @Test
    public void testClearExceptionHelperCacheForAppWhenDispose() throws Exception {
        URL baseUrl = DefaultMuleContextTestCase.class.getClassLoader().getResource(".");
        File file = new File(baseUrl.getFile() + "META-INF/services/" + ServiceType.EXCEPTION.getPath() + "/" + TEST_PROTOCOL + "-exception-mappings.properties");
        this.createExceptionMappingFile(file, INITIAL_VALUE);
        MuleContext ctx = new DefaultMuleContextFactory().createMuleContext();
        String value = ExceptionHelper.getErrorMapping((String)TEST_PROTOCOL, IllegalArgumentException.class, (MuleContext)ctx);
        Assert.assertThat((Object)value, (Matcher)Is.is((Object)INITIAL_VALUE));
        ctx.dispose();
        this.createExceptionMappingFile(file, VALUE_AFTER_REDEPLOY);
        ctx = new DefaultMuleContextFactory().createMuleContext();
        ctx.setExecutionClassLoader(this.getClass().getClassLoader());
        value = ExceptionHelper.getErrorMapping((String)TEST_PROTOCOL, IllegalArgumentException.class, (MuleContext)ctx);
        Assert.assertThat((Object)value, (Matcher)Is.is((Object)VALUE_AFTER_REDEPLOY));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createExceptionMappingFile(File exceptionMappingFile, String value) throws IOException {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(exceptionMappingFile);
            fileWriter.append("\njava.lang.IllegalArgumentException=" + value);
        }
        finally {
            if (fileWriter != null) {
                fileWriter.close();
            }
        }
    }

    @Test
    public void callSystemExceptionHandlerWhenExceptionIsMessagingException() throws Exception {
        MuleContext context = new DefaultMuleContextFactory().createMuleContext();
        context.setExceptionListener(this.mockSystemExceptionHandler);
        context.handleException((Exception)((Object)this.mockMessagingException));
        ((SystemExceptionHandler)Mockito.verify((Object)this.mockSystemExceptionHandler, (VerificationMode)VerificationModeFactory.times((int)1))).handleException((Exception)((Object)this.mockMessagingException), null);
    }
}

