/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.context;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.el.ExpressionLanguage;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.el.mvel.MVELExpressionLanguage;
import org.mule.mvel2.ImmutableElementException;
import org.mule.mvel2.PropertyAccessException;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.util.ExceptionUtils;

@RunWith(value=Parameterized.class)
public abstract class AbstractELTestCase
extends AbstractMuleContextTestCase {
    protected Variant variant;
    protected ExpressionLanguage expressionLanguage;

    public AbstractELTestCase(Variant variant) {
        this.variant = variant;
    }

    @Before
    public void setupExprssionEvaluator() throws Exception {
        this.expressionLanguage = this.getExpressionLanguage();
        if (this.expressionLanguage instanceof Initialisable) {
            ((Initialisable)this.expressionLanguage).initialise();
        }
    }

    protected Object evaluate(String expression) {
        switch (this.variant) {
            case EVALUATOR_LANGUAGE: {
                return this.expressionLanguage.evaluate(expression);
            }
            case EXPRESSION_MANAGER: {
                return muleContext.getExpressionManager().evaluate(expression, (MuleMessage)null);
            }
        }
        return null;
    }

    protected Object evaluate(String expression, MuleMessage message) {
        switch (this.variant) {
            case EVALUATOR_LANGUAGE: {
                return this.expressionLanguage.evaluate(expression, message);
            }
            case EXPRESSION_MANAGER: {
                return muleContext.getExpressionManager().evaluate(expression, message);
            }
        }
        return null;
    }

    protected Object evaluate(String expression, MuleEvent event) {
        switch (this.variant) {
            case EVALUATOR_LANGUAGE: {
                return this.expressionLanguage.evaluate(expression, event);
            }
            case EXPRESSION_MANAGER: {
                return muleContext.getExpressionManager().evaluate(expression, event.getMessage());
            }
        }
        return null;
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return Arrays.asList({Variant.EVALUATOR_LANGUAGE}, {Variant.EXPRESSION_MANAGER});
    }

    protected ExpressionLanguage getExpressionLanguage() throws Exception {
        return new MVELExpressionLanguage(muleContext);
    }

    protected void assertUnsupportedOperation(String expression) {
        try {
            this.evaluate(expression);
            Assert.fail((String)"ExpressionRuntimeException expected");
        }
        catch (ExpressionRuntimeException e) {
            Assert.assertEquals(UnsupportedOperationException.class, ExceptionUtils.getRootCause((Throwable)e).getClass());
        }
    }

    protected void assertUnsupportedOperation(String expression, MuleMessage message) {
        try {
            this.evaluate(expression, message);
            Assert.fail((String)"ExpressionRuntimeException expected");
        }
        catch (ExpressionRuntimeException e) {
            Assert.assertEquals(UnsupportedOperationException.class, ExceptionUtils.getRootCause((Throwable)e).getClass());
        }
    }

    protected void assertImmutableVariable(String expression) {
        try {
            this.evaluate(expression);
            Assert.fail((String)"ExpressionRuntimeException expected");
        }
        catch (ExpressionRuntimeException e) {
            Assert.assertEquals(ImmutableElementException.class, ExceptionUtils.getRootCause((Throwable)e).getClass());
        }
    }

    protected void assertImmutableVariable(String expression, MuleMessage message) {
        try {
            this.evaluate(expression, message);
            Assert.fail((String)"ExpressionRuntimeException expected");
        }
        catch (ExpressionRuntimeException e) {
            Assert.assertEquals(ImmutableElementException.class, ExceptionUtils.getRootCause((Throwable)e).getClass());
        }
    }

    protected void assertImmutableVariable(String expression, MuleEvent event) {
        try {
            this.evaluate(expression, event);
            Assert.fail((String)"ExpressionRuntimeException expected");
        }
        catch (ExpressionRuntimeException e) {
            Assert.assertEquals(ImmutableElementException.class, ExceptionUtils.getRootCause((Throwable)e).getClass());
        }
    }

    protected void assertFinalProperty(String expression) {
        try {
            this.evaluate(expression);
            Assert.fail((String)"ExpressionRuntimeException expected");
        }
        catch (ExpressionRuntimeException e) {
            Assert.assertEquals(PropertyAccessException.class, ExceptionUtils.getRootCause((Throwable)e).getClass());
        }
    }

    protected void assertFinalProperty(String expression, MuleMessage message) {
        try {
            this.evaluate(expression, message);
            Assert.fail((String)"ExpressionRuntimeException expected");
        }
        catch (ExpressionRuntimeException e) {
            Assert.assertEquals(PropertyAccessException.class, ExceptionUtils.getRootCause((Throwable)e).getClass());
        }
    }

    protected void assertFinalProperty(String expression, MuleEvent event) {
        try {
            this.evaluate(expression, event);
            Assert.fail((String)"ExpressionRuntimeException expected");
        }
        catch (ExpressionRuntimeException e) {
            Assert.assertEquals(PropertyAccessException.class, ExceptionUtils.getRootCause((Throwable)e).getClass());
        }
    }

    public static enum Variant {
        EXPRESSION_MANAGER,
        EVALUATOR_LANGUAGE;

    }
}

