/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.datetime;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.el.datetime.Instant;
import org.mule.api.el.datetime.Time;
import org.mule.el.datetime.DateTime;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class DateTimeTimeTestCase
extends AbstractMuleTestCase {
    protected Time now = new DateTime().withTimeZone("UTC").getTime();

    @Test
    public void milliSeconds() {
        junit.framework.Assert.assertTrue((this.now.getMilliSeconds() < 1000L ? 1 : 0) != 0);
    }

    @Test
    public void isBefore() {
        System.out.println(this.now.getHours());
        if (this.now.getHours() == 23) {
            junit.framework.Assert.assertTrue((boolean)this.now.isAfter((Instant)new DateTime().changeTimeZone("UTC").plusHours(1).getTime()));
        } else {
            junit.framework.Assert.assertTrue((boolean)this.now.isBefore((Instant)new DateTime().changeTimeZone("UTC").plusHours(1).getTime()));
        }
    }

    @Test
    public void isAfter() {
        if (this.now.getHours() == 0) {
            junit.framework.Assert.assertTrue((boolean)this.now.isBefore((Instant)new DateTime().withTimeZone("UTC").plusHours(-1).getTime()));
        } else {
            junit.framework.Assert.assertTrue((boolean)this.now.isAfter((Instant)new DateTime().withTimeZone("UTC").plusHours(-1).getTime()));
        }
    }

    @Test
    public void format() {
        SimpleDateFormat df = new SimpleDateFormat("hh:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        junit.framework.Assert.assertEquals((String)df.format(this.now.toDate()), (String)this.now.format("hh:mm:ss"));
    }

    @Test
    public void timeZone() {
        junit.framework.Assert.assertEquals((String)TimeZone.getTimeZone("UTC").getDisplayName(), (String)this.now.getTimeZone());
    }

    @Test
    public void plusSeconds() {
        junit.framework.Assert.assertEquals((int)((Calendar.getInstance().get(13) + 1) % 60), (int)this.now.plusSeconds(1).getSeconds());
    }

    @Test
    public void plusSecondsRollover() {
        junit.framework.Assert.assertEquals((int)1, (int)this.now.plusHours(172800).toCalendar().get(6));
    }

    @Test
    public void plusMinutes() {
        junit.framework.Assert.assertEquals((int)((Calendar.getInstance().get(12) + 1) % 60), (int)this.now.plusMinutes(1).getMinutes());
    }

    @Test
    public void plusMinutesRollover() {
        junit.framework.Assert.assertEquals((int)1, (int)this.now.plusHours(2880).toCalendar().get(6));
    }

    @Test
    public void plusHours() {
        junit.framework.Assert.assertEquals((int)((Calendar.getInstance(TimeZone.getTimeZone("UTC")).get(11) + 1) % 24), (int)this.now.plusHours(1).getHours());
    }

    @Test
    public void plusHoursRollover() {
        junit.framework.Assert.assertEquals((int)1, (int)this.now.plusHours(48).toCalendar().get(6));
    }

    @Test
    public void withTimeZone() {
        int hour = this.now.getHours();
        Assert.assertEquals((long)hour, (long)this.now.withTimeZone("GMT-03:00").getHours());
    }

    @Test
    public void changeTimeZone() {
        int hour = this.now.getHours();
        Assert.assertEquals((long)((hour + 24 - 3) % 24), (long)this.now.changeTimeZone("GMT-03:00").getHours());
    }

    @Test
    public void changeTimeZoneRollover() {
        junit.framework.Assert.assertEquals((int)1, (int)this.now.plusHours(48).toCalendar().get(6));
    }

    @Test
    public void seconds() {
        Assert.assertEquals((long)Calendar.getInstance(TimeZone.getTimeZone("UTC")).get(13), (long)this.now.getSeconds());
    }

    @Test
    public void minutes() {
        Assert.assertEquals((long)Calendar.getInstance(TimeZone.getTimeZone("UTC")).get(12), (long)this.now.getMinutes());
    }

    @Test
    public void hourOfDay() {
        Assert.assertEquals((long)Calendar.getInstance(TimeZone.getTimeZone("UTC")).get(11), (long)this.now.getHours());
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)DatatypeConverter.printTime((Calendar)Calendar.getInstance(TimeZone.getTimeZone("UTC"))).substring(0, 8), (Object)this.now.withTimeZone("UTC").toString().substring(0, 8));
    }

    @Test
    public void toDate() {
        Assert.assertEquals(Date.class, this.now.toDate().getClass());
    }

    @Test
    public void toCalendar() {
        Assert.assertEquals(GregorianCalendar.class, this.now.toCalendar().getClass());
    }

    @Test
    public void toXMLCalendar() throws DatatypeConfigurationException {
        Assert.assertTrue((boolean)(this.now.toXMLCalendar() instanceof XMLGregorianCalendar));
    }

    @Test
    public void fromDate() {
        Date date = new Date();
        date.setYear(0);
        date.setMonth(0);
        date.setDate(1);
        Assert.assertEquals((long)1900L, (long)new DateTime(date).getYear());
        Assert.assertEquals((long)1L, (long)new DateTime(date).getMonth());
        Assert.assertEquals((long)1L, (long)new DateTime(date).getDayOfMonth());
    }

    @Test
    public void fromCalendar() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1, 1900);
        cal.set(2, 0);
        cal.set(5, 1);
        Assert.assertEquals((long)1900L, (long)new DateTime((Calendar)cal).getYear());
        Assert.assertEquals((long)1L, (long)new DateTime((Calendar)cal).getMonth());
        Assert.assertEquals((long)1L, (long)new DateTime((Calendar)cal).getDayOfMonth());
    }

    @Test
    public void fromXMLCalendar() throws DatatypeConfigurationException {
        XMLGregorianCalendar xmlCal = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
        xmlCal.setYear(1900);
        xmlCal.setMonth(1);
        xmlCal.setDay(1);
        Assert.assertEquals((long)1900L, (long)new DateTime(xmlCal).getYear());
        Assert.assertEquals((long)1L, (long)new DateTime(xmlCal).getMonth());
        Assert.assertEquals((long)1L, (long)new DateTime(xmlCal).getDayOfMonth());
    }
}

