/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el.function;

import java.util.Calendar;
import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.MuleContext;
import org.mule.api.el.ExpressionExecutor;
import org.mule.api.el.ExpressionLanguageContext;
import org.mule.api.el.ExpressionLanguageFunction;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.el.datetime.DateTime;
import org.mule.el.function.DateTimeExpressionLanguageFuntion;
import org.mule.el.mvel.MVELExpressionExecutor;
import org.mule.el.mvel.MVELExpressionLanguageContext;
import org.mule.mvel2.ParserContext;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class DateTimeExpressionLanguageFunctionTestCase
extends AbstractMuleTestCase {
    protected ExpressionExecutor<MVELExpressionLanguageContext> expressionExecutor;
    protected MVELExpressionLanguageContext context;
    protected DateTimeExpressionLanguageFuntion dateTimeFunction;

    @Before
    public void setup() throws InitialisationException {
        ParserContext parserContext = new ParserContext();
        this.expressionExecutor = new MVELExpressionExecutor(parserContext);
        this.context = new MVELExpressionLanguageContext(parserContext, (MuleContext)Mockito.mock(MuleContext.class));
        this.dateTimeFunction = new DateTimeExpressionLanguageFuntion();
        this.context.declareFunction("dateTime", (ExpressionLanguageFunction)this.dateTimeFunction);
    }

    @Test
    public void parseISO8601String() throws Exception {
        DateTime dateTime = (DateTime)this.dateTimeFunction.call(new Object[]{"2013-03-17T00:23:00Z"}, (ExpressionLanguageContext)this.context);
        Assert.assertNotNull((Object)dateTime);
        Assert.assertEquals((long)2013L, (long)dateTime.getYear());
        Assert.assertEquals((long)3L, (long)dateTime.getMonth());
        Assert.assertEquals((long)17L, (long)dateTime.getDayOfMonth());
        Assert.assertEquals((long)0L, (long)dateTime.getHours());
        Assert.assertEquals((long)23L, (long)dateTime.getMinutes());
        Assert.assertEquals((long)0L, (long)dateTime.getSeconds());
        Assert.assertEquals((long)0L, (long)dateTime.toCalendar().get(15));
    }

    @Test
    public void parseISO8601StringWithTimeZome() throws Exception {
        DateTime dateTime = (DateTime)this.dateTimeFunction.call(new Object[]{"2013-03-17T00:23:00+07:00"}, (ExpressionLanguageContext)this.context);
        Assert.assertNotNull((Object)dateTime);
        Assert.assertEquals((long)2013L, (long)dateTime.getYear());
        Assert.assertEquals((long)3L, (long)dateTime.getMonth());
        Assert.assertEquals((long)17L, (long)dateTime.getDayOfMonth());
        Assert.assertEquals((long)0L, (long)dateTime.getHours());
        Assert.assertEquals((long)23L, (long)dateTime.getMinutes());
        Assert.assertEquals((long)0L, (long)dateTime.getSeconds());
        Assert.assertEquals((long)25200000L, (long)dateTime.toCalendar().get(15));
    }

    @Test
    public void parseFormattedString() throws Exception {
        DateTime dateTime = (DateTime)this.dateTimeFunction.call(new Object[]{"17/3/13 00:23:00", "dd/M/yy hh:mm:ss"}, (ExpressionLanguageContext)this.context);
        Assert.assertNotNull((Object)dateTime);
        Assert.assertEquals((long)2013L, (long)dateTime.getYear());
        Assert.assertEquals((long)3L, (long)dateTime.getMonth());
        Assert.assertEquals((long)17L, (long)dateTime.getDayOfMonth());
        Assert.assertEquals((long)0L, (long)dateTime.getHours());
        Assert.assertEquals((long)23L, (long)dateTime.getMinutes());
        Assert.assertEquals((long)0L, (long)dateTime.getSeconds());
        Assert.assertEquals((long)0L, (long)dateTime.toCalendar().get(15));
    }

    @Test
    public void parseFormattedStringWithTimeZone() throws Exception {
        DateTime dateTime = (DateTime)this.dateTimeFunction.call(new Object[]{"17/3/13 00:23:00 -0700", "dd/M/yy hh:mm:ss ZZ"}, (ExpressionLanguageContext)this.context);
        Assert.assertNotNull((Object)dateTime);
        Assert.assertEquals((long)2013L, (long)dateTime.getYear());
        Assert.assertEquals((long)3L, (long)dateTime.getMonth());
        Assert.assertEquals((long)17L, (long)dateTime.getDayOfMonth());
        Assert.assertEquals((long)0L, (long)dateTime.getHours());
        Assert.assertEquals((long)23L, (long)dateTime.getMinutes());
        Assert.assertEquals((long)0L, (long)dateTime.getSeconds());
        Assert.assertEquals((long)-25200000L, (long)dateTime.toCalendar().get(15));
    }

    @Test
    public void convertDate() throws Exception {
        Date date = new Date();
        DateTime dateTime = (DateTime)this.dateTimeFunction.call(new Object[]{date}, (ExpressionLanguageContext)this.context);
        Assert.assertNotNull((Object)dateTime);
        Assert.assertEquals((long)(date.getYear() + 1900), (long)dateTime.getYear());
        Assert.assertEquals((long)(date.getMonth() + 1), (long)dateTime.getMonth());
        Assert.assertEquals((long)date.getDate(), (long)dateTime.getDayOfMonth());
        Assert.assertEquals((long)date.getHours(), (long)dateTime.getHours());
        Assert.assertEquals((long)date.getMinutes(), (long)dateTime.getMinutes());
        Assert.assertEquals((long)date.getSeconds(), (long)dateTime.getSeconds());
    }

    @Test
    public void convertCalendar() throws Exception {
        Calendar cal = Calendar.getInstance();
        DateTime dateTime = (DateTime)this.dateTimeFunction.call(new Object[]{cal}, (ExpressionLanguageContext)this.context);
        Assert.assertNotNull((Object)dateTime);
        Assert.assertEquals((long)cal.get(1), (long)dateTime.getYear());
        Assert.assertEquals((long)(cal.get(2) + 1), (long)dateTime.getMonth());
        Assert.assertEquals((long)cal.get(5), (long)dateTime.getDayOfMonth());
        Assert.assertEquals((long)cal.get(11), (long)dateTime.getHours());
        Assert.assertEquals((long)cal.get(12), (long)dateTime.getMinutes());
        Assert.assertEquals((long)cal.get(13), (long)dateTime.getSeconds());
    }
}

