/*
 * Decompiled with CFR 0.152.
 */
package org.mule.lifecycle;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.lifecycle.LifecycleState;
import org.mule.api.lifecycle.LifecycleStateEnabled;
import org.mule.api.lifecycle.Startable;
import org.mule.context.notification.NotificationException;
import org.mule.lifecycle.PrimaryNodeLifecycleNotificationListener;
import org.mule.tck.junit4.AbstractMuleTestCase;

@RunWith(value=MockitoJUnitRunner.class)
public class PrimaryNodeLifecycleNotificationListenerTestCase
extends AbstractMuleTestCase {
    @Mock
    private MuleContext mockMuleContext;
    @Mock
    private Startable mockStartable;
    @Mock
    private ServerNotification mockServerNotification;
    private StartableAndLifecycleState mockStartableAndLifecycleState;
    private StartableAndLifecycleStateEnabled mockStartableAndLifecycleStateEnabled;
    private PrimaryNodeLifecycleNotificationListener notificationListener;

    @Before
    public void setUpTest() {
        this.notificationListener = new PrimaryNodeLifecycleNotificationListener(this.mockStartable, this.mockMuleContext);
    }

    @Test
    public void testRegister() throws NotificationException {
        this.notificationListener.register();
        ((MuleContext)Mockito.verify((Object)this.mockMuleContext, (VerificationMode)Mockito.times((int)1))).registerListener((ServerNotificationListener)this.notificationListener);
    }

    @Test
    public void testUnregister() throws NotificationException {
        this.notificationListener.unregister();
        ((MuleContext)Mockito.verify((Object)this.mockMuleContext, (VerificationMode)Mockito.times((int)1))).unregisterListener((ServerNotificationListener)this.notificationListener);
    }

    @Test
    public void testOnNotificationWithStartable() throws MuleException {
        this.notificationListener.onNotification(this.mockServerNotification);
        ((Startable)Mockito.verify((Object)this.mockStartable, (VerificationMode)Mockito.times((int)1))).start();
    }

    @Test
    public void testOnNotificationWithLifecycleStateStarted() throws MuleException {
        this.mockStartableAndLifecycleState = (StartableAndLifecycleState)Mockito.mock(StartableAndLifecycleState.class);
        Mockito.when((Object)this.mockStartableAndLifecycleState.isStarted()).thenReturn((Object)true);
        this.notificationListener = new PrimaryNodeLifecycleNotificationListener((Startable)this.mockStartableAndLifecycleState, this.mockMuleContext);
        this.notificationListener.onNotification(this.mockServerNotification);
        ((StartableAndLifecycleState)Mockito.verify((Object)this.mockStartableAndLifecycleState, (VerificationMode)Mockito.times((int)1))).start();
    }

    @Test
    public void testOnNotificationWithLifecycleStateStopped() throws MuleException {
        this.mockStartableAndLifecycleState = (StartableAndLifecycleState)Mockito.mock(StartableAndLifecycleState.class);
        Mockito.when((Object)this.mockStartableAndLifecycleState.isStarted()).thenReturn((Object)false);
        this.notificationListener = new PrimaryNodeLifecycleNotificationListener((Startable)this.mockStartableAndLifecycleState, this.mockMuleContext);
        this.notificationListener.onNotification(this.mockServerNotification);
        ((StartableAndLifecycleState)Mockito.verify((Object)this.mockStartableAndLifecycleState, (VerificationMode)Mockito.times((int)0))).start();
    }

    @Test
    public void testOnNotificationWithLifecycleStateEnabledStarted() throws MuleException {
        this.mockStartableAndLifecycleStateEnabled = (StartableAndLifecycleStateEnabled)Mockito.mock(StartableAndLifecycleStateEnabled.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
        Mockito.when((Object)this.mockStartableAndLifecycleStateEnabled.getLifecycleState().isStarted()).thenReturn((Object)true);
        this.notificationListener = new PrimaryNodeLifecycleNotificationListener((Startable)this.mockStartableAndLifecycleStateEnabled, this.mockMuleContext);
        this.notificationListener.onNotification(this.mockServerNotification);
        ((StartableAndLifecycleStateEnabled)Mockito.verify((Object)this.mockStartableAndLifecycleStateEnabled, (VerificationMode)Mockito.times((int)1))).start();
    }

    @Test
    public void testOnNotificationWithLifecycleStateEnabledStopped() throws MuleException {
        this.mockStartableAndLifecycleStateEnabled = (StartableAndLifecycleStateEnabled)Mockito.mock(StartableAndLifecycleStateEnabled.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
        Mockito.when((Object)this.mockStartableAndLifecycleStateEnabled.getLifecycleState().isStarted()).thenReturn((Object)false);
        this.notificationListener = new PrimaryNodeLifecycleNotificationListener((Startable)this.mockStartableAndLifecycleStateEnabled, this.mockMuleContext);
        this.notificationListener.onNotification(this.mockServerNotification);
        ((StartableAndLifecycleStateEnabled)Mockito.verify((Object)this.mockStartableAndLifecycleStateEnabled, (VerificationMode)Mockito.times((int)0))).start();
    }

    private static interface StartableAndLifecycleState
    extends Startable,
    LifecycleState {
    }

    private static interface StartableAndLifecycleStateEnabled
    extends Startable,
    LifecycleStateEnabled {
    }
}

