/*
 * Decompiled with CFR 0.152.
 */
package org.mule.registry;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.registry.Registry;
import org.mule.construct.Flow;
import org.mule.registry.TransientRegistry;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.mule.TestConnector;

public class RegistryBrokerTestCase
extends AbstractMuleContextTestCase {
    private String tracker;

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.tracker = new String();
    }

    @Override
    protected boolean isStartContext() {
        return false;
    }

    @Test
    public void testCrossRegistryLifecycleOrder() throws MuleException {
        TransientRegistry reg1 = new TransientRegistry(muleContext);
        reg1.initialise();
        TransientRegistry reg2 = new TransientRegistry(muleContext);
        reg2.initialise();
        reg1.registerObject("conn", (Object)new LifecycleTrackerConnector("conn", muleContext));
        reg2.registerObject("conn2", (Object)new LifecycleTrackerConnector("conn2", muleContext));
        reg1.registerObject("flow", (Object)new LifecycleTrackerFlow("flow", muleContext));
        reg2.registerObject("flow2", (Object)new LifecycleTrackerFlow("flow2", muleContext));
        muleContext.addRegistry((Registry)reg1);
        muleContext.addRegistry((Registry)reg2);
        muleContext.start();
        Assert.assertEquals((Object)"conn2-start conn-start flow2-start flow-start ", (Object)this.tracker.toString());
        this.tracker = new String();
        muleContext.stop();
        Assert.assertEquals((Object)"flow2-stop flow-stop conn2-stop conn-stop ", (Object)this.tracker);
    }

    class LifecycleTrackerFlow
    extends Flow {
        public LifecycleTrackerFlow(String name, MuleContext muleContext) {
            super(name, muleContext);
        }

        protected void doStart() throws MuleException {
            super.doStart();
            RegistryBrokerTestCase.this.tracker = RegistryBrokerTestCase.this.tracker + (this.name + "-start ");
        }

        protected void doStop() throws MuleException {
            super.doStop();
            RegistryBrokerTestCase.this.tracker = RegistryBrokerTestCase.this.tracker + (this.name + "-stop ");
        }
    }

    class LifecycleTrackerConnector
    extends TestConnector {
        public LifecycleTrackerConnector(String name, MuleContext context) {
            super(context);
            this.name = name;
        }

        @Override
        protected void doStart() {
            super.doStart();
            RegistryBrokerTestCase.this.tracker = RegistryBrokerTestCase.this.tracker + (this.name + "-start ");
        }

        @Override
        protected void doStop() {
            super.doStop();
            RegistryBrokerTestCase.this.tracker = RegistryBrokerTestCase.this.tracker + (this.name + "-stop ");
        }
    }
}

