/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.routing.AsynchronousUntilSuccessfulProcessingStrategy;
import org.mule.routing.UntilSuccessfulConfiguration;
import org.mule.routing.filters.ExpressionFilter;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.util.concurrent.Latch;
import org.mule.util.store.SimpleMemoryObjectStore;

@SmallTest
public class AsynchronousUntilSuccessfulProcessingStrategyTestCase
extends AbstractMuleTestCase {
    private static final int DEFAULT_RETRIES = 4;
    private static final int DEFAULT_TRIES = 5;
    private final Latch exceptionStrategyLatch = new Latch();
    private UntilSuccessfulConfiguration mockUntilSuccessfulConfiguration = (UntilSuccessfulConfiguration)Mockito.mock(UntilSuccessfulConfiguration.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private MuleEvent mockEvent = (MuleEvent)Mockito.mock(MuleEvent.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private MessageProcessor mockRoute = (MessageProcessor)Mockito.mock(MessageProcessor.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private ExpressionFilter mockAlwaysTrueFailureExpressionFilter = (ExpressionFilter)Mockito.mock(ExpressionFilter.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private ScheduledThreadPoolExecutor mockScheduledPool = (ScheduledThreadPoolExecutor)Mockito.mock(ScheduledThreadPoolExecutor.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private SimpleMemoryObjectStore<MuleEvent> objectStore = new SimpleMemoryObjectStore();
    private boolean failRoute;
    private CountDownLatch routeCountDownLatch;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.mockAlwaysTrueFailureExpressionFilter.accept((MuleMessage)Matchers.any(MuleMessage.class))).thenReturn((Object)true);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getRoute()).thenReturn((Object)this.mockRoute);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getAckExpression()).thenReturn(null);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getMaxRetries()).thenReturn((Object)4);
        Mockito.when((Object)this.mockEvent.getMessage().getInvocationProperty("process.attempt.count", (Object)1)).thenAnswer((Answer)new Answer<Object>(){
            private int numberOfAttempts = 0;

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                return this.numberOfAttempts++;
            }
        });
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getThreadingProfile().createScheduledPool(Matchers.anyString())).thenReturn((Object)this.mockScheduledPool);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getObjectStore()).thenReturn(this.objectStore);
        this.configureMockScheduledPoolToInvokeRunnableInNewThread();
        this.configureMockRouteToCountDownRouteLatch();
        this.configureExceptionStrategyToReleaseLatchWhenExecuted();
    }

    @Test(expected=InitialisationException.class)
    public void failWhenObjectStoreIsNull() throws Exception {
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getObjectStore()).thenReturn(null);
        this.createProcessingStrategy();
    }

    @Test
    public void alwaysFail() throws Exception {
        this.executeUntilSuccessfulFailingRoute();
        this.waitUntilRouteIsExecuted();
    }

    @Test
    public void alwaysFailUsingFailureExpression() throws Exception {
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getDlqMP()).thenReturn(null);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getFailureExpressionFilter()).thenReturn((Object)this.mockAlwaysTrueFailureExpressionFilter);
        this.executeUntilSuccessfulFailingRoute();
        this.waitUntilRouteIsExecuted();
        this.waitUntilExceptionStrategyIsExecuted();
    }

    @Test
    public void successfulExecution() throws Exception {
        this.executeUntilSuccessful();
        this.waitUntilRouteIsExecuted();
        ((MessageProcessor)Mockito.verify((Object)this.mockRoute, (VerificationMode)Mockito.times((int)1))).process(this.mockEvent);
    }

    @Test
    public void successfulExecutionWithAckExpression() throws Exception {
        String ackExpression = "some-expression";
        String expressionEvalutaionResult = "new payload";
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getAckExpression()).thenReturn((Object)ackExpression);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getMuleContext().getExpressionManager().evaluate(ackExpression, this.mockEvent)).thenReturn((Object)expressionEvalutaionResult);
        this.executeUntilSuccessful();
        this.waitUntilRouteIsExecuted();
        ((MessageProcessor)Mockito.verify((Object)this.mockRoute, (VerificationMode)Mockito.times((int)1))).process(this.mockEvent);
        ((ExpressionManager)Mockito.verify((Object)this.mockUntilSuccessfulConfiguration.getMuleContext().getExpressionManager(), (VerificationMode)Mockito.times((int)1))).evaluate(ackExpression, this.mockEvent);
        ((MuleMessage)Mockito.verify((Object)this.mockEvent.getMessage(), (VerificationMode)Mockito.times((int)1))).setPayload((Object)expressionEvalutaionResult);
    }

    private void executeUntilSuccessfulFailingRoute() throws Exception {
        this.failRoute = true;
        this.routeCountDownLatch = new CountDownLatch(5);
        AsynchronousUntilSuccessfulProcessingStrategy processingStrategy = this.createProcessingStrategy();
        processingStrategy.route(this.mockEvent);
    }

    private void executeUntilSuccessful() throws Exception {
        this.routeCountDownLatch = new Latch();
        AsynchronousUntilSuccessfulProcessingStrategy processingStrategy = this.createProcessingStrategy();
        processingStrategy.route(this.mockEvent);
    }

    private void configureMockRouteToCountDownRouteLatch() throws MuleException {
        Mockito.when((Object)this.mockRoute.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                AsynchronousUntilSuccessfulProcessingStrategyTestCase.this.routeCountDownLatch.countDown();
                if (AsynchronousUntilSuccessfulProcessingStrategyTestCase.this.failRoute) {
                    throw new RuntimeException("expected failure");
                }
                return invocationOnMock.getArguments()[0];
            }
        });
    }

    private void configureMockScheduledPoolToInvokeRunnableInNewThread() {
        Mockito.when(this.mockScheduledPool.schedule((Callable)Matchers.any(Callable.class), Matchers.anyLong(), (TimeUnit)((Object)Matchers.any(TimeUnit.class)))).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(final InvocationOnMock invocationOnMock) throws Throwable {
                Assert.assertThat((Object)((Long)invocationOnMock.getArguments()[1]), (Matcher)Is.is((Object)AsynchronousUntilSuccessfulProcessingStrategyTestCase.this.mockUntilSuccessfulConfiguration.getSecondsBetweenRetries()));
                Assert.assertThat((Object)((Object)((TimeUnit)((Object)invocationOnMock.getArguments()[2]))), (Matcher)Is.is((Object)((Object)TimeUnit.SECONDS)));
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ((Callable)invocationOnMock.getArguments()[0]).call();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }).start();
                return null;
            }
        });
    }

    private void waitUntilRouteIsExecuted() throws InterruptedException {
        if (!this.routeCountDownLatch.await(2000L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)("route should be executed " + this.routeCountDownLatch.getCount() + " times"));
        }
    }

    private AsynchronousUntilSuccessfulProcessingStrategy createProcessingStrategy() throws Exception {
        AsynchronousUntilSuccessfulProcessingStrategy processingStrategy = new AsynchronousUntilSuccessfulProcessingStrategy(){

            protected MuleEvent threadSafeCopy(MuleEvent event) {
                return event;
            }
        };
        processingStrategy.setUntilSuccessfulConfiguration(this.mockUntilSuccessfulConfiguration);
        processingStrategy.initialise();
        processingStrategy.start();
        return processingStrategy;
    }

    private void waitUntilExceptionStrategyIsExecuted() throws InterruptedException {
        if (!this.exceptionStrategyLatch.await(1000L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"exception strategy should be executed");
        }
    }

    private void configureExceptionStrategyToReleaseLatchWhenExecuted() {
        Mockito.when((Object)this.mockEvent.getFlowConstruct().getExceptionListener().handleException((Exception)Matchers.any(Exception.class), (MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer(new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                AsynchronousUntilSuccessfulProcessingStrategyTestCase.this.exceptionStrategyLatch.release();
                return null;
            }
        });
    }
}

