/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.RoutePathNotFoundException;
import org.mule.routing.AbstractDynamicRoundRobinTestCase;
import org.mule.routing.IdentifiableDynamicRouteResolver;
import org.mule.routing.RoundRobinRoutingStrategy;

public class RoundRobinRoutingStrategyTestCase
extends AbstractDynamicRoundRobinTestCase {
    private RoundRobinRoutingStrategy roundRobinRoutingStrategy;

    @Before
    public void setUp() {
        this.roundRobinRoutingStrategy = new RoundRobinRoutingStrategy(muleContext, new IdentifiableDynamicRouteResolver(){

            public String getRouteIdentifier(MuleEvent event) throws MessagingException {
                return (String)event.getMessage().getInvocationProperty("id");
            }

            public List<MessageProcessor> resolveRoutes(MuleEvent event) throws MessagingException {
                return null;
            }
        });
    }

    @Test(expected=RoutePathNotFoundException.class)
    public void testNullMessageProcessors() throws MessagingException {
        this.roundRobinRoutingStrategy.route(null, null);
    }

    @Test(expected=RoutePathNotFoundException.class)
    public void testEmptyMessageProcessors() throws MessagingException {
        this.roundRobinRoutingStrategy.route(null, Collections.EMPTY_LIST);
    }

    @Test
    public void testRoute() throws Exception {
        List<MessageProcessor> messageProcessors = this.getMessageProcessorsList();
        MuleEvent eventToRouteId1 = this.getEventWithId("ID_1");
        MuleEvent eventToRouteId2 = this.getEventWithId("ID_2");
        Assert.assertEquals((Object)"a", (Object)this.roundRobinRoutingStrategy.route(eventToRouteId1, messageProcessors).getMessage().getPayloadAsString());
        Assert.assertEquals((Object)"b", (Object)this.roundRobinRoutingStrategy.route(eventToRouteId1, messageProcessors).getMessage().getPayloadAsString());
        Assert.assertEquals((Object)"a", (Object)this.roundRobinRoutingStrategy.route(eventToRouteId2, messageProcessors).getMessage().getPayloadAsString());
        Assert.assertEquals((Object)"c", (Object)this.roundRobinRoutingStrategy.route(eventToRouteId1, messageProcessors).getMessage().getPayloadAsString());
        Assert.assertEquals((Object)"b", (Object)this.roundRobinRoutingStrategy.route(eventToRouteId2, messageProcessors).getMessage().getPayloadAsString());
        Assert.assertEquals((Object)"c", (Object)this.roundRobinRoutingStrategy.route(eventToRouteId2, messageProcessors).getMessage().getPayloadAsString());
        Assert.assertEquals((Object)"a", (Object)this.roundRobinRoutingStrategy.route(eventToRouteId1, messageProcessors).getMessage().getPayloadAsString());
    }

    @Test
    public void testRouteWithFailingMessageProcessor() throws Exception {
        List<MessageProcessor> messageProcessors = this.getMessageProcessorsListWithFailingMessageProcessor();
        MuleEvent eventToRoute = this.getEventWithId("ID_1");
        Assert.assertEquals((Object)"a", (Object)this.roundRobinRoutingStrategy.route(eventToRoute, messageProcessors).getMessage().getPayloadAsString());
        try {
            this.roundRobinRoutingStrategy.route(eventToRoute, messageProcessors);
            Assert.fail((String)"Exception was expected");
        }
        catch (MessagingException me) {
            Assert.assertEquals((Object)"Failure!", (Object)me.getCause().getMessage());
        }
        Assert.assertEquals((Object)"b", (Object)this.roundRobinRoutingStrategy.route(eventToRoute, messageProcessors).getMessage().getPayloadAsString());
        Assert.assertEquals((Object)"a", (Object)this.roundRobinRoutingStrategy.route(eventToRoute, messageProcessors).getMessage().getPayloadAsString());
    }

    @Test
    public void testNullIdentifier() throws Exception {
        List<MessageProcessor> messageProcessors = this.getMessageProcessorsList();
        MuleEvent eventToRoute = this.getEventWithId(null);
        Assert.assertEquals((Object)"a", (Object)this.roundRobinRoutingStrategy.route(eventToRoute, messageProcessors).getMessage().getPayloadAsString());
        Assert.assertEquals((Object)"b", (Object)this.roundRobinRoutingStrategy.route(eventToRoute, messageProcessors).getMessage().getPayloadAsString());
        Assert.assertEquals((Object)"c", (Object)this.roundRobinRoutingStrategy.route(eventToRoute, messageProcessors).getMessage().getPayloadAsString());
        Assert.assertEquals((Object)"a", (Object)this.roundRobinRoutingStrategy.route(eventToRoute, messageProcessors).getMessage().getPayloadAsString());
    }
}

