/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Answers;
import org.mockito.Mockito;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.VoidMuleEvent;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.RoutingException;
import org.mule.api.store.ListableObjectStore;
import org.mule.routing.SynchronousUntilSuccessfulProcessingStrategy;
import org.mule.routing.UntilSuccessfulConfiguration;
import org.mule.routing.filters.ExpressionFilter;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class SynchronousUntilSuccessfulProcessingStrategyTestCase
extends AbstractMuleTestCase {
    private static final int DEFAULT_RETRIES = 4;
    private UntilSuccessfulConfiguration mockUntilSuccessfulConfiguration = (UntilSuccessfulConfiguration)Mockito.mock(UntilSuccessfulConfiguration.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private MuleEvent mockEvent = (MuleEvent)Mockito.mock(MuleEvent.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private MessageProcessor mockRoute = (MessageProcessor)Mockito.mock(MessageProcessor.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private ExpressionFilter mockAlwaysTrueFailureExpressionFilter = (ExpressionFilter)Mockito.mock(ExpressionFilter.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private ThreadingProfile mockThreadingProfile = (ThreadingProfile)Mockito.mock(ThreadingProfile.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private ListableObjectStore<MuleEvent> mockObjectStore = (ListableObjectStore)Mockito.mock(ListableObjectStore.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());

    @Before
    public void setUp() {
        Mockito.when((Object)this.mockAlwaysTrueFailureExpressionFilter.accept((MuleMessage)Mockito.any(MuleMessage.class))).thenReturn((Object)true);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getRoute()).thenReturn((Object)this.mockRoute);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getAckExpression()).thenReturn(null);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getMaxRetries()).thenReturn((Object)4);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getThreadingProfile()).thenReturn(null);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getObjectStore()).thenReturn(null);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getDlqMP()).thenReturn(null);
    }

    @Test(expected=InitialisationException.class)
    public void failWhenThreadingProfileIsConfigured() throws Exception {
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getThreadingProfile()).thenReturn((Object)this.mockThreadingProfile);
        this.createProcessingStrategy();
    }

    @Test(expected=InitialisationException.class)
    public void failWhenObjectStoreIsConfigured() throws Exception {
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getObjectStore()).thenReturn(this.mockObjectStore);
        this.createProcessingStrategy();
    }

    @Test(expected=InitialisationException.class)
    public void failWhenDlqIsConfigured() throws Exception {
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getObjectStore()).thenReturn(this.mockObjectStore);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getDlqMP()).thenReturn((Object)this.mockRoute);
        this.createProcessingStrategy();
    }

    @Test
    public void alwaysFail() throws MuleException {
        Mockito.when((Object)this.mockRoute.process((MuleEvent)Mockito.any(MuleEvent.class))).thenThrow(new Throwable[]{new RuntimeException("expected failure")});
        SynchronousUntilSuccessfulProcessingStrategy processingStrategy = this.createProcessingStrategy();
        try {
            processingStrategy.route(this.mockEvent);
            Assert.fail((String)"processing should thrown exception");
        }
        catch (MessagingException e) {
            Assert.assertThat((Object)((Object)e), (Matcher)IsInstanceOf.instanceOf(RoutingException.class));
            ((MessageProcessor)Mockito.verify((Object)this.mockRoute, (VerificationMode)VerificationModeFactory.times((int)5))).process(this.mockEvent);
        }
    }

    @Test
    public void alwaysFailUsingFailureExpression() throws MuleException {
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getFailureExpressionFilter()).thenReturn((Object)this.mockAlwaysTrueFailureExpressionFilter);
        SynchronousUntilSuccessfulProcessingStrategy processingStrategy = this.createProcessingStrategy();
        try {
            processingStrategy.route(this.mockEvent);
            Assert.fail((String)"processing should thrown exception");
        }
        catch (MessagingException e) {
            Assert.assertThat((Object)((Object)e), (Matcher)IsInstanceOf.instanceOf(RoutingException.class));
            ((MessageProcessor)Mockito.verify((Object)this.mockRoute, (VerificationMode)VerificationModeFactory.times((int)5))).process(this.mockEvent);
            ((ExpressionFilter)Mockito.verify((Object)this.mockAlwaysTrueFailureExpressionFilter, (VerificationMode)VerificationModeFactory.times((int)5))).accept((MuleMessage)Mockito.any(MuleMessage.class));
        }
    }

    @Test
    public void successfulExecution() throws Exception {
        SynchronousUntilSuccessfulProcessingStrategy processingStrategy = this.createProcessingStrategy();
        Mockito.when((Object)this.mockRoute.process(this.mockEvent)).thenReturn((Object)this.mockEvent);
        Assert.assertThat((Object)processingStrategy.route(this.mockEvent), (Matcher)Is.is((Object)this.mockEvent));
        ((MessageProcessor)Mockito.verify((Object)this.mockRoute, (VerificationMode)VerificationModeFactory.times((int)1))).process(this.mockEvent);
    }

    @Test
    public void successfulExecutionWithAckExpression() throws Exception {
        String ackExpression = "some-expression";
        String expressionEvalutaionResult = "new payload";
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getAckExpression()).thenReturn((Object)ackExpression);
        Mockito.when((Object)this.mockUntilSuccessfulConfiguration.getMuleContext().getExpressionManager().evaluate(ackExpression, this.mockEvent)).thenReturn((Object)expressionEvalutaionResult);
        SynchronousUntilSuccessfulProcessingStrategy processingStrategy = this.createProcessingStrategy();
        Mockito.when((Object)this.mockRoute.process(this.mockEvent)).thenReturn((Object)this.mockEvent);
        Assert.assertThat((Object)processingStrategy.route(this.mockEvent), (Matcher)Is.is((Object)this.mockEvent));
        ((MessageProcessor)Mockito.verify((Object)this.mockRoute, (VerificationMode)VerificationModeFactory.times((int)1))).process(this.mockEvent);
        ((ExpressionManager)Mockito.verify((Object)this.mockUntilSuccessfulConfiguration.getMuleContext().getExpressionManager(), (VerificationMode)VerificationModeFactory.times((int)1))).evaluate(ackExpression, this.mockEvent);
        ((MuleMessage)Mockito.verify((Object)this.mockEvent.getMessage(), (VerificationMode)VerificationModeFactory.times((int)1))).setPayload((Object)expressionEvalutaionResult);
    }

    @Test
    public void successfulWithNullResponseFromRoute() throws Exception {
        Mockito.when((Object)this.mockRoute.process(this.mockEvent)).thenReturn(null);
        SynchronousUntilSuccessfulProcessingStrategy processingStrategy = this.createProcessingStrategy();
        Assert.assertThat((Object)((VoidMuleEvent)processingStrategy.route(this.mockEvent)), (Matcher)Is.is((Object)VoidMuleEvent.getInstance()));
    }

    @Test
    public void successfulWithNullEventResponseFromRoute() throws Exception {
        Mockito.when((Object)this.mockRoute.process(this.mockEvent)).thenReturn((Object)VoidMuleEvent.getInstance());
        SynchronousUntilSuccessfulProcessingStrategy processingStrategy = this.createProcessingStrategy();
        Assert.assertThat((Object)((VoidMuleEvent)processingStrategy.route(this.mockEvent)), (Matcher)Is.is((Object)VoidMuleEvent.getInstance()));
    }

    private SynchronousUntilSuccessfulProcessingStrategy createProcessingStrategy() throws InitialisationException {
        SynchronousUntilSuccessfulProcessingStrategy processingStrategy = new SynchronousUntilSuccessfulProcessingStrategy();
        processingStrategy.setUntilSuccessfulConfiguration(this.mockUntilSuccessfulConfiguration);
        processingStrategy.initialise();
        return processingStrategy;
    }
}

