/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.CouldNotRouteOutboundMessageException;
import org.mule.api.routing.OutboundRouterCatchAllStrategy;
import org.mule.api.routing.RoutingException;
import org.mule.api.routing.filter.Filter;
import org.mule.message.DefaultExceptionPayload;
import org.mule.routing.LoggingCatchAllStrategy;
import org.mule.routing.filters.RegExFilter;
import org.mule.routing.outbound.DefaultOutboundRouterCollection;
import org.mule.routing.outbound.ExceptionBasedRouter;
import org.mule.routing.outbound.OutboundRoutingTestEvent;
import org.mule.routing.outbound.RouterTestUtils;
import org.mule.tck.MuleEventCheckAnswer;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class ExceptionBasedRouterTestCase
extends AbstractMuleContextTestCase {
    public ExceptionBasedRouterTestCase() {
        this.setStartContext(true);
    }

    @Test
    public void testSuccessfulExceptionRouterSynchronous() throws Exception {
        DefaultOutboundRouterCollection messageRouter = new DefaultOutboundRouterCollection();
        messageRouter.setCatchAllStrategy((OutboundRouterCatchAllStrategy)new LoggingCatchAllStrategy());
        OutboundEndpoint endpoint1 = muleContext.getEndpointFactory().getOutboundEndpoint("test://Dummy1?exchangePattern=request-response");
        OutboundEndpoint mockendpoint1 = RouterTestUtils.createMockEndpoint(endpoint1);
        OutboundEndpoint endpoint2 = muleContext.getEndpointFactory().getOutboundEndpoint("test://Dummy2?exchangePattern=request-response");
        OutboundEndpoint mockendpoint2 = RouterTestUtils.createMockEndpoint(endpoint2);
        OutboundEndpoint endpoint3 = muleContext.getEndpointFactory().getOutboundEndpoint("test://Dummy3?exchangePattern=request-response");
        OutboundEndpoint mockendpoint3 = RouterTestUtils.createMockEndpoint(endpoint3);
        ExceptionBasedRouter router = new ExceptionBasedRouter();
        router.setMuleContext(muleContext);
        RegExFilter filter = new RegExFilter("(.*) event");
        router.setFilter((Filter)filter);
        ArrayList<OutboundEndpoint> endpoints = new ArrayList<OutboundEndpoint>();
        endpoints.add(mockendpoint1);
        endpoints.add(mockendpoint2);
        endpoints.add(mockendpoint3);
        router.setRoutes(endpoints);
        Assert.assertEquals((Object)filter, (Object)router.getFilter());
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", muleContext);
        OutboundRoutingTestEvent event = new OutboundRoutingTestEvent((MuleMessage)message, null, muleContext);
        Mockito.when((Object)mockendpoint1.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer(event));
        MuleSession session = (MuleSession)Mockito.mock(MuleSession.class);
        MuleEvent result = router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, session, muleContext));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)message, (Object)result.getMessage());
    }

    @Test
    public void testBothFailing() throws Exception {
        OutboundEndpoint endpoint1 = muleContext.getEndpointFactory().getOutboundEndpoint("test://AlwaysFail");
        OutboundEndpoint mockendpoint1 = RouterTestUtils.createMockEndpoint(endpoint1);
        OutboundEndpoint endpoint2 = muleContext.getEndpointFactory().getOutboundEndpoint("test://AlwaysFail");
        OutboundEndpoint mockendpoint2 = RouterTestUtils.createMockEndpoint(endpoint2);
        ExceptionBasedRouter router = new ExceptionBasedRouter();
        router.setMuleContext(muleContext);
        RegExFilter filter = new RegExFilter("(.*) event");
        router.setFilter((Filter)filter);
        ArrayList<OutboundEndpoint> endpoints = new ArrayList<OutboundEndpoint>();
        endpoints.add(mockendpoint1);
        endpoints.add(mockendpoint2);
        router.setRoutes(endpoints);
        Assert.assertEquals((Object)filter, (Object)router.getFilter());
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", muleContext);
        Assert.assertTrue((boolean)router.isMatch((MuleMessage)message));
        MuleSession session = (MuleSession)Mockito.mock(MuleSession.class);
        DefaultMuleEvent eventToThrow = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.ONE_WAY, null, session);
        RoutingException rex = new RoutingException((MuleEvent)eventToThrow, (MessageProcessor)endpoint1);
        Mockito.when((Object)mockendpoint1.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer((MuleException)((Object)rex)));
        Mockito.when((Object)mockendpoint2.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer((MuleException)((Object)rex)));
        MuleEvent result = null;
        try {
            result = router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, session, muleContext));
            Assert.fail((String)"Should have thrown exception as both targets would have failed");
        }
        catch (CouldNotRouteOutboundMessageException e) {
            // empty catch block
        }
        Assert.assertNull((String)"Async call should've returned null.", result);
        message = new DefaultMuleMessage((Object)"test event", muleContext);
    }

    @Test
    public void testFailFirstSuccessSecondSync() throws Exception {
        OutboundEndpoint endpoint1 = ExceptionBasedRouterTestCase.getTestOutboundEndpoint("TestFailEndpoint", "test://Failure?exchangePattern=request-response");
        OutboundEndpoint mockendpoint1 = RouterTestUtils.createMockEndpoint(endpoint1);
        OutboundEndpoint endpoint2 = ExceptionBasedRouterTestCase.getTestOutboundEndpoint("TestSuccessEndpoint", "test://Success?exchangePattern=request-response");
        OutboundEndpoint mockendpoint2 = RouterTestUtils.createMockEndpoint(endpoint2);
        ExceptionBasedRouter router = new ExceptionBasedRouter();
        router.setMuleContext(muleContext);
        router.addRoute((MessageProcessor)mockendpoint1);
        router.addRoute((MessageProcessor)mockendpoint2);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", muleContext);
        DefaultMuleMessage expectedResultMessage = new DefaultMuleMessage((Object)"Return event", muleContext);
        OutboundRoutingTestEvent event = new OutboundRoutingTestEvent((MuleMessage)expectedResultMessage, null, muleContext);
        Assert.assertTrue((boolean)router.isMatch((MuleMessage)message));
        MuleSession session = (MuleSession)Mockito.mock(MuleSession.class);
        DefaultMuleEvent eventToThrow = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.ONE_WAY, null, session);
        RoutingException rex = new RoutingException((MuleEvent)eventToThrow, (MessageProcessor)endpoint1);
        Mockito.when((Object)mockendpoint1.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer((MuleException)((Object)rex)));
        Mockito.when((Object)mockendpoint2.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer(event));
        MuleEvent actualResult = router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, session, muleContext));
        Assert.assertEquals((String)"Got an invalid return message.", (Object)expectedResultMessage, (Object)actualResult.getMessage());
    }

    @Test
    public void testFailFirstSuccessSecondAsync() throws Exception {
        OutboundEndpoint endpoint1 = ExceptionBasedRouterTestCase.getTestOutboundEndpoint("TestFailEndpoint", "test://Failure?exchangePattern=request-response");
        OutboundEndpoint mockendpoint1 = RouterTestUtils.createMockEndpoint(endpoint1);
        OutboundEndpoint endpoint2 = ExceptionBasedRouterTestCase.getTestOutboundEndpoint("TestSuccessEndpoint", "test://Success?exchangePattern=one-way");
        OutboundEndpoint mockendpoint2 = RouterTestUtils.createMockEndpoint(endpoint2);
        ExceptionBasedRouter router = new ExceptionBasedRouter();
        router.setMuleContext(muleContext);
        router.addRoute((MessageProcessor)mockendpoint1);
        router.addRoute((MessageProcessor)mockendpoint2);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", muleContext);
        DefaultMuleMessage expectedResultMessage = new DefaultMuleMessage((Object)"Return event", muleContext);
        OutboundRoutingTestEvent event = new OutboundRoutingTestEvent((MuleMessage)expectedResultMessage, null, muleContext);
        Assert.assertTrue((boolean)router.isMatch((MuleMessage)message));
        MuleSession session = (MuleSession)Mockito.mock(MuleSession.class);
        DefaultMuleEvent eventToThrow = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.ONE_WAY, null, session);
        RoutingException rex = new RoutingException((MuleEvent)eventToThrow, (MessageProcessor)endpoint1);
        Mockito.when((Object)mockendpoint1.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer((MuleException)((Object)rex)));
        Mockito.when((Object)mockendpoint2.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer(event));
        MuleEvent actualResult = router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, session, muleContext));
        Assert.assertNull((String)"Async call should not return any results.", (Object)actualResult);
    }

    @Test
    public void testFirstHadExceptionPayloadSuccessSecondSyncWithExceptionPayload() throws Exception {
        OutboundEndpoint endpoint1 = ExceptionBasedRouterTestCase.getTestOutboundEndpoint("TestFailEndpoint", "test://Failure?exchangePattern=request-response");
        OutboundEndpoint mockendpoint1 = RouterTestUtils.createMockEndpoint(endpoint1);
        OutboundEndpoint endpoint2 = ExceptionBasedRouterTestCase.getTestOutboundEndpoint("TestSuccessEndpoint", "test://Success?exchangePattern=request-response");
        OutboundEndpoint mockendpoint2 = RouterTestUtils.createMockEndpoint(endpoint2);
        ExceptionBasedRouter router = new ExceptionBasedRouter();
        router.setMuleContext(muleContext);
        router.addRoute((MessageProcessor)mockendpoint1);
        router.addRoute((MessageProcessor)mockendpoint2);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", muleContext);
        DefaultMuleMessage expectedResultMessage = new DefaultMuleMessage((Object)"Return event", muleContext);
        OutboundRoutingTestEvent expectedResultEvent = new OutboundRoutingTestEvent((MuleMessage)expectedResultMessage, null, muleContext);
        Assert.assertTrue((boolean)router.isMatch((MuleMessage)message));
        DefaultMuleMessage exPayloadMessage = new DefaultMuleMessage((Object)"there was a failure", muleContext);
        exPayloadMessage.setExceptionPayload((ExceptionPayload)new DefaultExceptionPayload((Throwable)new RuntimeException()));
        OutboundRoutingTestEvent exPayloadMessageEvent = new OutboundRoutingTestEvent((MuleMessage)exPayloadMessage, null, muleContext);
        MuleSession session = (MuleSession)Mockito.mock(MuleSession.class);
        Mockito.when((Object)mockendpoint1.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer(exPayloadMessageEvent));
        Mockito.when((Object)mockendpoint2.process((MuleEvent)Matchers.any(MuleEvent.class))).thenAnswer((Answer)new MuleEventCheckAnswer(expectedResultEvent));
        MuleEvent actualResult = router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, session, muleContext));
        Assert.assertEquals((String)"Got an invalid return message.", (Object)expectedResultMessage, (Object)actualResult.getMessage());
    }
}

