/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.requestreply;

import java.beans.ExceptionListener;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.resource.spi.work.Work;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.WorkManager;
import org.mule.api.context.WorkManagerSource;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.ResponseTimeoutException;
import org.mule.api.service.Service;
import org.mule.api.source.MessageSource;
import org.mule.processor.LaxAsyncInterceptingMessageProcessor;
import org.mule.routing.requestreply.AbstractAsyncRequestReplyRequester;
import org.mule.tck.SensingNullMessageProcessor;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.util.concurrent.Latch;
import org.mule.util.store.MuleObjectStoreManager;

public class AsyncRequestReplyRequesterTestCase
extends AbstractMuleContextTestCase
implements ExceptionListener {
    TestAsyncRequestReplyRequester asyncReplyMP;

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        muleContext.getRegistry().registerObject("_muleObjectStoreManager", (Object)new MuleObjectStoreManager());
    }

    @Override
    protected void doTearDown() throws Exception {
        if (this.asyncReplyMP != null) {
            this.asyncReplyMP.stop();
            this.asyncReplyMP.dispose();
        }
        super.doTearDown();
    }

    @Test
    public void testSingleEventNoTimeout() throws Exception {
        this.asyncReplyMP = new TestAsyncRequestReplyRequester(muleContext);
        SensingNullMessageProcessor target = this.getSensingNullMessageProcessor();
        this.asyncReplyMP.setListener(target);
        this.asyncReplyMP.setReplySource(target.getMessageSource());
        MuleEvent event = AsyncRequestReplyRequesterTestCase.getTestEvent((Object)"Test Message", (FlowConstruct)AsyncRequestReplyRequesterTestCase.getTestService());
        MuleEvent resultEvent = this.asyncReplyMP.process(event);
        Assert.assertEquals((Object)event.getMessageAsString(), (Object)resultEvent.getMessageAsString());
        Assert.assertEquals((Object)event.getMessage().getUniqueId(), (Object)resultEvent.getMessage().getUniqueId());
    }

    @Test
    public void testSingleEventNoTimeoutAsync() throws Exception {
        this.asyncReplyMP = new TestAsyncRequestReplyRequester(muleContext);
        SensingNullMessageProcessor target = this.getSensingNullMessageProcessor();
        LaxAsyncInterceptingMessageProcessor asyncMP = new LaxAsyncInterceptingMessageProcessor(new WorkManagerSource(){

            public WorkManager getWorkManager() throws MuleException {
                return muleContext.getWorkManager();
            }
        }, null);
        asyncMP.setListener((MessageProcessor)target);
        this.asyncReplyMP.setListener((MessageProcessor)asyncMP);
        this.asyncReplyMP.setReplySource(target.getMessageSource());
        MuleEvent event = AsyncRequestReplyRequesterTestCase.getTestEvent((Object)"Test Message", AsyncRequestReplyRequesterTestCase.getTestService(), AsyncRequestReplyRequesterTestCase.getTestInboundEndpoint(MessageExchangePattern.ONE_WAY));
        MuleEvent resultEvent = this.asyncReplyMP.process(event);
        Assert.assertEquals((Object)event.getMessageAsString(), (Object)resultEvent.getMessageAsString());
        Assert.assertEquals((Object)event.getMessage().getUniqueId(), (Object)resultEvent.getMessage().getUniqueId());
    }

    @Test
    public void testSingleEventTimeout() throws Exception {
        this.asyncReplyMP = new TestAsyncRequestReplyRequester(muleContext);
        this.asyncReplyMP.setTimeout(1L);
        SensingNullMessageProcessor target = this.getSensingNullMessageProcessor();
        target.setWaitTime(3000L);
        LaxAsyncInterceptingMessageProcessor asyncMP = new LaxAsyncInterceptingMessageProcessor(new WorkManagerSource(){

            public WorkManager getWorkManager() throws MuleException {
                return muleContext.getWorkManager();
            }
        }, null);
        asyncMP.setListener((MessageProcessor)target);
        this.asyncReplyMP.setListener((MessageProcessor)asyncMP);
        this.asyncReplyMP.setReplySource(target.getMessageSource());
        MuleEvent event = AsyncRequestReplyRequesterTestCase.getTestEvent((Object)"Test Message", AsyncRequestReplyRequesterTestCase.getTestService(), AsyncRequestReplyRequesterTestCase.getTestInboundEndpoint(MessageExchangePattern.ONE_WAY));
        try {
            this.asyncReplyMP.process(event);
            Assert.fail((String)"ResponseTimeoutException expected");
        }
        catch (Exception e) {
            Assert.assertEquals(ResponseTimeoutException.class, e.getClass());
        }
    }

    @Test
    public void returnsNullWhenInterruptedWhileWaitingForReply() throws Exception {
        final Latch fakeLatch = new Latch(){

            public void await() throws InterruptedException {
                throw new InterruptedException();
            }
        };
        this.asyncReplyMP = new TestAsyncRequestReplyRequester(muleContext){

            protected Latch createEventLock() {
                return fakeLatch;
            }
        };
        final MuleEvent event = AsyncRequestReplyRequesterTestCase.getTestEvent((Object)"Test Message", AsyncRequestReplyRequesterTestCase.getTestService(), AsyncRequestReplyRequesterTestCase.getTestInboundEndpoint(MessageExchangePattern.ONE_WAY));
        final CountDownLatch processingLatch = new CountDownLatch(1);
        MessageProcessor target = (MessageProcessor)Mockito.mock(MessageProcessor.class);
        this.asyncReplyMP.setListener(target);
        MessageSource messageSource = (MessageSource)Mockito.mock(MessageSource.class);
        this.asyncReplyMP.setReplySource(messageSource);
        final boolean[] exceptionThrown = new boolean[1];
        final Object[] responseEvent = new Object[1];
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    responseEvent[0] = AsyncRequestReplyRequesterTestCase.this.asyncReplyMP.process(event);
                }
                catch (MuleException e) {
                    exceptionThrown[0] = true;
                }
                finally {
                    processingLatch.countDown();
                }
            }
        });
        thread.start();
        Assert.assertTrue((boolean)processingLatch.await(5000L, TimeUnit.MILLISECONDS));
        Assert.assertFalse((boolean)exceptionThrown[0]);
        junit.framework.Assert.assertNull((Object)responseEvent[0]);
    }

    @Test
    public void testMultiple() throws Exception {
        this.asyncReplyMP = new TestAsyncRequestReplyRequester(muleContext);
        SensingNullMessageProcessor target = this.getSensingNullMessageProcessor();
        target.setWaitTime(50L);
        LaxAsyncInterceptingMessageProcessor asyncMP = new LaxAsyncInterceptingMessageProcessor(new WorkManagerSource(){

            public WorkManager getWorkManager() throws MuleException {
                return muleContext.getWorkManager();
            }
        }, null);
        asyncMP.setListener((MessageProcessor)target);
        this.asyncReplyMP.setListener((MessageProcessor)asyncMP);
        this.asyncReplyMP.setReplySource(target.getMessageSource());
        final InboundEndpoint inboundEndpoint = AsyncRequestReplyRequesterTestCase.getTestInboundEndpoint(MessageExchangePattern.ONE_WAY);
        final Service service = AsyncRequestReplyRequesterTestCase.getTestService();
        final AtomicInteger count = new AtomicInteger();
        for (int i = 0; i < 500; ++i) {
            muleContext.getWorkManager().scheduleWork(new Work(){

                public void run() {
                    try {
                        MuleEvent event = AbstractMuleContextTestCase.getTestEvent((Object)"Test Message", service, inboundEndpoint);
                        MuleEvent resultEvent = AsyncRequestReplyRequesterTestCase.this.asyncReplyMP.process(event);
                        Assert.assertEquals((Object)event.getMessageAsString(), (Object)resultEvent.getMessageAsString());
                        Assert.assertEquals((Object)event.getMessage().getUniqueId(), (Object)resultEvent.getMessage().getUniqueId());
                        count.incrementAndGet();
                        AsyncRequestReplyRequesterTestCase.this.logger.debug((Object)("Finished " + count.get()));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public void release() {
                }
            });
        }
        while (count.get() < 500) {
            Thread.sleep(10L);
        }
    }

    @Override
    public void exceptionThrown(Exception e) {
        e.printStackTrace();
        Assert.fail((String)e.getMessage());
    }

    class TestAsyncRequestReplyRequester
    extends AbstractAsyncRequestReplyRequester {
        TestAsyncRequestReplyRequester(MuleContext muleContext) throws MuleException {
            this.setMuleContext(muleContext);
            this.initialise();
            this.start();
        }
    }
}

