/*
 * Decompiled with CFR 0.152.
 */
package org.mule.source;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.source.MessageSource;
import org.mule.source.StartableCompositeMessageSource;
import org.mule.tck.SensingNullMessageProcessor;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.util.ObjectUtils;

public class StartableCompositeMessageSourceTestCase
extends AbstractMuleContextTestCase {
    protected SensingNullMessageProcessor listener;
    protected SensingNullMessageProcessor listener2;
    protected StartableCompositeMessageSource compositeSource;
    protected MuleEvent testEvent;
    protected NullMessageSource source;

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.listener = this.getSensingNullMessageProcessor();
        this.listener2 = this.getSensingNullMessageProcessor();
        this.compositeSource = this.getCompositeSource();
        this.testEvent = StartableCompositeMessageSourceTestCase.getTestEvent("Test Message");
        this.source = new NullMessageSource(this.testEvent);
    }

    protected StartableCompositeMessageSource getCompositeSource() {
        return new StartableCompositeMessageSource();
    }

    @Test
    public void testAddSourceStopped() throws MuleException {
        this.compositeSource.setListener((MessageProcessor)this.listener);
        this.compositeSource.addSource((MessageSource)this.source);
        this.source.triggerSource();
        Assert.assertNull((Object)this.listener.event);
        this.source.start();
        try {
            this.source.triggerSource();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertNull((Object)this.listener.event);
        this.compositeSource.start();
        this.source.triggerSource();
        Assert.assertEquals((Object)this.testEvent, (Object)this.listener.event);
    }

    @Test
    public void testAddSourceStarted() throws MuleException {
        this.compositeSource.setListener((MessageProcessor)this.listener);
        this.compositeSource.start();
        this.compositeSource.addSource((MessageSource)this.source);
        this.source.triggerSource();
        Assert.assertEquals((Object)this.testEvent, (Object)this.listener.event);
    }

    @Test
    public void testRemoveSource() throws MuleException {
        this.compositeSource.setListener((MessageProcessor)this.listener);
        this.compositeSource.addSource((MessageSource)this.source);
        this.compositeSource.start();
        this.source.triggerSource();
        Assert.assertEquals((Object)this.testEvent, (Object)this.listener.event);
        this.listener.clear();
        this.compositeSource.removeSource((MessageSource)this.source);
        this.source.triggerSource();
        Assert.assertNull((Object)this.listener.event);
    }

    @Test
    public void testSetListenerStarted() throws MuleException {
        this.compositeSource.addSource((MessageSource)this.source);
        this.compositeSource.setListener((MessageProcessor)this.listener);
        this.compositeSource.start();
        this.source.triggerSource();
        Assert.assertEquals((Object)this.testEvent, (Object)this.listener.event);
        this.listener.clear();
        this.compositeSource.setListener((MessageProcessor)this.listener2);
        this.source.triggerSource();
        Assert.assertNull((Object)this.listener.event);
        Assert.assertEquals((Object)this.testEvent, (Object)this.listener2.event);
    }

    @Test
    public void testStart() throws MuleException {
        this.compositeSource.setListener((MessageProcessor)this.listener);
        this.compositeSource.addSource((MessageSource)this.source);
        this.source.triggerSource();
        Assert.assertNull((Object)this.listener.event);
        this.compositeSource.start();
        this.source.triggerSource();
        Assert.assertEquals((Object)this.testEvent, (Object)this.listener.event);
    }

    @Test
    public void testStartNoListener() throws MuleException {
        this.compositeSource.addSource((MessageSource)this.source);
        try {
            this.compositeSource.start();
            Assert.fail((String)"Exception excepted");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testStop() throws MuleException {
        this.compositeSource.setListener((MessageProcessor)this.listener);
        this.compositeSource.addSource((MessageSource)this.source);
        this.compositeSource.start();
        this.compositeSource.stop();
        this.source.triggerSource();
        Assert.assertNull((Object)this.listener.event);
    }

    protected class NullMessageSource
    implements MessageSource,
    Startable,
    Stoppable {
        MuleEvent event;
        MessageProcessor listener;
        boolean started = false;

        public NullMessageSource(MuleEvent event) {
            this.event = event;
        }

        public void setListener(MessageProcessor listener) {
            this.listener = listener;
        }

        public void triggerSource() throws MuleException {
            if (this.started && this.listener != null) {
                this.listener.process(this.event);
            }
        }

        public void start() throws MuleException {
            this.started = true;
        }

        public void stop() throws MuleException {
            this.started = false;
        }

        public String toString() {
            return ObjectUtils.toString((Object)this);
        }
    }
}

