/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit4;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.io.LineIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;
import org.mule.RequestContext;
import org.mule.tck.junit4.rule.WarningTimeout;
import org.mule.util.ClassUtils;
import org.mule.util.IOUtils;
import org.mule.util.MuleUrlStreamHandlerFactory;
import org.mule.util.StringMessageUtils;
import org.mule.util.StringUtils;
import org.mule.util.SystemUtils;

public abstract class AbstractMuleTestCase {
    public static final String TESTING_MODE_PROPERTY_NAME = "mule.testingMode";
    public static final int DEFAULT_TEST_TIMEOUT_SECS = 60;
    public static final String TEST_TIMEOUT_SYSTEM_PROPERTY = "mule.test.timeoutSecs";
    private static final boolean verbose;
    private static Boolean excluded;
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    private boolean offline = "true".equalsIgnoreCase(System.getProperty("org.mule.offline"));
    private int testTimeoutSecs = this.getTimeoutSystemProperty();
    @Rule
    public TestName name = new TestName();
    @Rule
    public TestRule globalTimeout = this.createTestTimeoutRule();

    public AbstractMuleTestCase() {
        if (excluded == null) {
            excluded = this.isTestIncludedInExclusionFile(this);
        }
    }

    protected TestRule createTestTimeoutRule() {
        int millisecondsTimeout = this.getTestTimeoutSecs() * 1000;
        if (this.isFailOnTimeout()) {
            return new Timeout(millisecondsTimeout);
        }
        return new WarningTimeout(millisecondsTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isTestIncludedInExclusionFile(AbstractMuleTestCase test) {
        boolean result;
        block5: {
            result = false;
            final String testName = test.getClass().getName();
            try {
                URL classUrl = ClassUtils.getClassPathRoot(test.getClass());
                URLClassLoader tempClassLoader = new URLClassLoader(new URL[]{classUrl});
                URL fileUrl = tempClassLoader.getResource("mule-test-exclusions.txt");
                if (fileUrl == null) break block5;
                InputStream in = null;
                try {
                    in = fileUrl.openStream();
                    LineIterator lines = IOUtils.lineIterator((InputStream)in, (String)"UTF-8");
                    result = IteratorUtils.filteredIterator((Iterator)lines, (Predicate)new Predicate(){

                        public boolean evaluate(Object object) {
                            return StringUtils.equals((String)testName, (String)StringUtils.trimToEmpty((String)((String)object)));
                        }
                    }).hasNext();
                }
                finally {
                    IOUtils.closeQuietly((InputStream)in);
                }
            }
            catch (IOException ioex) {
                // empty catch block
            }
        }
        return result;
    }

    protected int getTimeoutSystemProperty() {
        String timeoutString = System.getProperty(TEST_TIMEOUT_SYSTEM_PROPERTY, null);
        if (timeoutString == null) {
            String variableName = TEST_TIMEOUT_SYSTEM_PROPERTY.toUpperCase().replace(".", "_");
            timeoutString = System.getenv(variableName);
        }
        int result = 60;
        if (timeoutString != null) {
            try {
                result = Integer.parseInt(timeoutString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    protected boolean isDisabledInThisEnvironment() {
        return false;
    }

    protected boolean isExcluded() {
        return excluded;
    }

    protected boolean isDisabledInThisEnvironment(String testMethodName) {
        return false;
    }

    public boolean isOffline(String method) {
        if (this.offline) {
            this.logger.warn((Object)StringMessageUtils.getBoilerPlate((String)("Working offline cannot run test: " + method), (char)'=', (int)80));
        }
        return this.offline;
    }

    public int getTestTimeoutSecs() {
        return this.testTimeoutSecs;
    }

    @Before
    public final void initializeMuleTest() {
        this.printTestHeader();
        this.skipTestWhenExcluded();
        this.skipTestWhenDisabledInCurrentEnvironment();
    }

    private void printTestHeader() {
        if (verbose) {
            System.out.println(StringMessageUtils.getBoilerPlate((String)this.getTestHeader(), (char)'=', (int)80));
        }
    }

    protected String getTestHeader() {
        return "Testing: " + this.name.getMethodName();
    }

    private void skipTestWhenExcluded() {
        Assume.assumeThat((Object)this, (Matcher)new BaseMatcher<AbstractMuleTestCase>(){

            public boolean matches(Object o) {
                return !AbstractMuleTestCase.this.isExcluded();
            }

            public void describeTo(Description description) {
                description.appendText("Test " + AbstractMuleTestCase.this.name.getMethodName() + " is excluded");
            }
        });
    }

    private void skipTestWhenDisabledInCurrentEnvironment() {
        Assume.assumeThat((Object)this, (Matcher)new BaseMatcher<AbstractMuleTestCase>(){

            public boolean matches(Object o) {
                return !AbstractMuleTestCase.this.isDisabledInThisEnvironment() && !AbstractMuleTestCase.this.isDisabledInThisEnvironment(AbstractMuleTestCase.this.name.getMethodName());
            }

            public void describeTo(Description description) {
                description.appendText("Test " + AbstractMuleTestCase.this.name.getMethodName() + " disabled in this environment");
            }
        });
    }

    protected boolean isFailOnTimeout() {
        return true;
    }

    @After
    public final void clearRequestContext() {
        RequestContext.clear();
    }

    @AfterClass
    public static final void clearExcludedFlag() {
        excluded = null;
    }

    static {
        excluded = null;
        String muleOpts = SystemUtils.getenv((String)"MULE_TEST_OPTS");
        if (StringUtils.isNotBlank((String)muleOpts)) {
            Map parsedOpts = SystemUtils.parsePropertyDefinitions((String)muleOpts);
            String optVerbose = (String)parsedOpts.get("mule.verbose");
            verbose = Boolean.valueOf(optVerbose);
        } else {
            verbose = true;
        }
        System.setProperty(TESTING_MODE_PROPERTY_NAME, "");
        MuleUrlStreamHandlerFactory.installUrlStreamHandlerFactory();
    }
}

