/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.junit4.rule;

import org.junit.rules.TemporaryFolder;

public class SystemPropertyTemporaryFolder
extends TemporaryFolder {
    private final String propertyName;
    private String originalPropertyValue;

    public SystemPropertyTemporaryFolder(String propertyName) {
        this.propertyName = propertyName;
    }

    protected void before() throws Throwable {
        super.before();
        this.originalPropertyValue = System.setProperty(this.propertyName, this.getRoot().getCanonicalPath());
    }

    protected void after() {
        if (this.originalPropertyValue == null) {
            System.clearProperty(this.propertyName);
        } else {
            System.setProperty(this.propertyName, this.originalPropertyValue);
        }
        super.after();
    }
}

