/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.store;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.api.store.ListableObjectStore;
import org.mule.api.store.ObjectStore;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.util.store.MuleObjectStoreManager;

@RunWith(value=Parameterized.class)
public class MuleObjectStoreManagerIntegrationTestCase
extends AbstractMuleContextTestCase {
    public static final String OBJECT_KEY = "key";
    public static final String OBJECT_KEY_VALUE_1 = "value";
    public static final String OBJECT_KEY_VALUE_2 = "anotherValue";
    private final ObjectStoreFactory objectStoreFactory;

    public MuleObjectStoreManagerIntegrationTestCase(ObjectStoreFactory objectStoreFactory) {
        this.objectStoreFactory = objectStoreFactory;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({new ObjectStoreFactory(false, ObjectStoreType.DEFAULT)}, {new ObjectStoreFactory(true, ObjectStoreType.DEFAULT)}, {new ObjectStoreFactory(false, ObjectStoreType.USER)}, {new ObjectStoreFactory(true, ObjectStoreType.USER)});
    }

    @Before
    public void injectMuleContext() {
        this.objectStoreFactory.setMuleObjectStoreManager((MuleObjectStoreManager)muleContext.getRegistry().get("_muleObjectStoreManager"));
    }

    @Test
    public void partitionObjectStoreDoesNotCollide() throws Exception {
        Object os = this.objectStoreFactory.createObjectStore("myOs");
        Object os2 = this.objectStoreFactory.createObjectStore("myOs2");
        os.store((Serializable)((Object)OBJECT_KEY), (Serializable)((Object)OBJECT_KEY_VALUE_1));
        os2.store((Serializable)((Object)OBJECT_KEY), (Serializable)((Object)OBJECT_KEY_VALUE_2));
        Assert.assertThat((Object)os.contains((Serializable)((Object)OBJECT_KEY)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((String)((Object)os.retrieve((Serializable)((Object)OBJECT_KEY)))), (Matcher)Is.is((Object)OBJECT_KEY_VALUE_1));
        Assert.assertThat((Object)os2.contains((Serializable)((Object)OBJECT_KEY)), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)((String)((Object)os2.retrieve((Serializable)((Object)OBJECT_KEY)))), (Matcher)Is.is((Object)OBJECT_KEY_VALUE_2));
        Assert.assertThat((Object)((String)((Object)os.remove((Serializable)((Object)OBJECT_KEY)))), (Matcher)Is.is((Object)OBJECT_KEY_VALUE_1));
        Assert.assertThat((Object)((String)((Object)os2.remove((Serializable)((Object)OBJECT_KEY)))), (Matcher)Is.is((Object)OBJECT_KEY_VALUE_2));
    }

    @Test
    public void maxEntriesIsHonored() throws Exception {
        int expirationInterval = 1000;
        int maxEntries = 5;
        Object os = this.objectStoreFactory.createObjectStore("myOs", 5, 0, 1000);
        os.store((Serializable)Integer.valueOf(0), (Serializable)Integer.valueOf(0));
        this.ensureMilisecondChanged();
        for (int i = 1; i < 6; ++i) {
            os.store((Serializable)Integer.valueOf(i), (Serializable)Integer.valueOf(i));
        }
        PollingProber prober = new PollingProber(5000L, 1000L);
        prober.check(new JUnitProbe((ObjectStore)os){
            final /* synthetic */ ObjectStore val$os;
            {
                this.val$os = objectStore;
            }

            @Override
            public boolean test() throws Exception {
                Assert.assertThat((Object)this.val$os.contains((Serializable)Integer.valueOf(0)), (Matcher)Is.is((Object)false));
                for (int i = 1; i < 6; ++i) {
                    Assert.assertThat((Object)this.val$os.contains((Serializable)Integer.valueOf(i)), (Matcher)Is.is((Object)true));
                }
                return true;
            }

            @Override
            public String describeFailure() {
                return "max entries were not honoured";
            }
        });
    }

    @Test
    public void expirationIntervalWithLowTTL() throws Exception {
        int maxEntries = 5;
        int entryTTL = 10;
        int expirationInterval = 100;
        final ListableObjectStore os = (ListableObjectStore)this.objectStoreFactory.createObjectStore("myOs", maxEntries, entryTTL, expirationInterval);
        for (int i = 0; i < maxEntries; ++i) {
            os.store((Serializable)Integer.valueOf(i), (Serializable)Integer.valueOf(i));
        }
        PollingProber prober = new PollingProber(1000L, expirationInterval);
        prober.check(new JUnitProbe(){

            @Override
            public boolean test() throws Exception {
                return os.allKeys().isEmpty();
            }

            @Override
            public String describeFailure() {
                return "not all entries were evicted";
            }
        });
    }

    @Test
    public void expirationIntervalWithHighTTLPersistentObjectStore() throws Exception {
        int i;
        int maxEntries = 5;
        int entryTTL = 10000;
        ListableObjectStore os = (ListableObjectStore)this.objectStoreFactory.createObjectStore("myOs", maxEntries, entryTTL, 100);
        os.store((Serializable)Integer.valueOf(0), (Serializable)Integer.valueOf(0));
        this.ensureMilisecondChanged();
        for (i = 1; i < maxEntries; ++i) {
            os.store((Serializable)Integer.valueOf(i), (Serializable)Integer.valueOf(i));
        }
        os.store((Serializable)((Object)OBJECT_KEY), (Serializable)((Object)OBJECT_KEY_VALUE_1));
        Thread.sleep(entryTTL / 5);
        Assert.assertThat((Object)os.allKeys().size(), (Matcher)Is.is((Object)maxEntries));
        for (i = 1; i < maxEntries; ++i) {
            Assert.assertThat((Object)os.contains((Serializable)Integer.valueOf(i)), (Matcher)Is.is((Object)true));
        }
        Assert.assertThat((Object)os.contains((Serializable)((Object)OBJECT_KEY)), (Matcher)Is.is((Object)true));
    }

    private void ensureMilisecondChanged() throws InterruptedException {
        Thread.sleep(2L);
    }

    @Test
    public void onlySizeBoundedObjectStore() throws Exception {
        int maxEntries = 5;
        boolean entryTTL = false;
        final ListableObjectStore os = (ListableObjectStore)this.objectStoreFactory.createObjectStore("myOs", 5, 0, 1000);
        os.store((Serializable)Integer.valueOf(0), (Serializable)Integer.valueOf(0));
        this.ensureMilisecondChanged();
        for (int i = 1; i < 6; ++i) {
            os.store((Serializable)Integer.valueOf(i), (Serializable)Integer.valueOf(i));
        }
        PollingProber prober = new PollingProber(5000L, 1000L);
        prober.check(new JUnitProbe(){

            @Override
            public boolean test() throws Exception {
                Assert.assertThat((Object)os.allKeys().size(), (Matcher)Is.is((Object)5));
                for (int i = 1; i < 6; ++i) {
                    Assert.assertThat((Object)os.contains((Serializable)Integer.valueOf(i)), (Matcher)Is.is((Object)true));
                }
                return true;
            }

            @Override
            public String describeFailure() {
                return "objectStore was not trimmed";
            }
        });
    }

    @Test
    public void storeUsingBigKey() throws Exception {
        ListableObjectStore os = (ListableObjectStore)this.objectStoreFactory.createObjectStore("myOs");
        StringBuffer bigKey = new StringBuffer();
        for (int i = 0; i < 50; ++i) {
            bigKey.append("abcdefghijklmnopqrstuvwxyz");
        }
        os.store((Serializable)((Object)bigKey.toString()), (Serializable)Integer.valueOf(1));
        Assert.assertThat((Object)((Integer)os.retrieve((Serializable)((Object)bigKey.toString()))), (Matcher)Is.is((Object)1));
    }

    private static class ObjectStoreFactory {
        private final boolean isPersistent;
        private final ObjectStoreType objectStoreType;
        private MuleObjectStoreManager muleObjectStoreManager;

        public ObjectStoreFactory(boolean isPersistent, ObjectStoreType objectStoreType) {
            this.isPersistent = isPersistent;
            this.objectStoreType = objectStoreType;
        }

        public void setMuleObjectStoreManager(MuleObjectStoreManager muleObjectStoreManager) {
            this.muleObjectStoreManager = muleObjectStoreManager;
        }

        public <T extends ObjectStore<? extends Serializable>> T createObjectStore(String name) {
            if (this.objectStoreType.equals((Object)ObjectStoreType.USER)) {
                return (T)this.muleObjectStoreManager.getUserObjectStore(name, this.isPersistent);
            }
            return (T)this.muleObjectStoreManager.getObjectStore(name, this.isPersistent);
        }

        public <T extends ObjectStore<? extends Serializable>> T createObjectStore(String name, int maxEntries, int entryTTL, int expirationInterval) {
            if (this.objectStoreType.equals((Object)ObjectStoreType.USER)) {
                return (T)this.muleObjectStoreManager.getUserObjectStore(name, this.isPersistent, maxEntries, entryTTL, expirationInterval);
            }
            return (T)this.muleObjectStoreManager.getObjectStore(name, this.isPersistent, maxEntries, entryTTL, expirationInterval);
        }
    }

    private static enum ObjectStoreType {
        DEFAULT,
        USER;

    }
}

