/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.xmlsecurity;

import javax.xml.parsers.DocumentBuilderFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.util.xmlsecurity.XMLSecureFactories;

public class XMLSecureFactoriesTestCase {
    @Test
    public void createsTheCorrectInstances() {
        XMLSecureFactories xmlSecureFactories = XMLSecureFactories.createDefault();
        Assert.assertThat((Object)xmlSecureFactories.getDocumentBuilderFactory(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)xmlSecureFactories.getSAXParserFactory(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)xmlSecureFactories.getXMLInputFactory(), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void cachesXmlFactory() {
        DocumentBuilderFactory documentBuilderFactoryOne = XMLSecureFactories.createDefault().getDocumentBuilderFactory();
        DocumentBuilderFactory documentBuilderFactoryTwo = XMLSecureFactories.createDefault().getDocumentBuilderFactory();
        Assert.assertThat((Object)documentBuilderFactoryOne, (Matcher)CoreMatchers.sameInstance((Object)documentBuilderFactoryTwo));
    }

    @Test
    public void handlesDifferentConfigurations() {
        DocumentBuilderFactory insecureFactoryOne = XMLSecureFactories.createWithConfig((Boolean)true, (Boolean)true).getDocumentBuilderFactory();
        DocumentBuilderFactory secureFactoryOne = XMLSecureFactories.createWithConfig((Boolean)true, (Boolean)false).getDocumentBuilderFactory();
        DocumentBuilderFactory insecureFactoryTwo = XMLSecureFactories.createWithConfig((Boolean)true, (Boolean)true).getDocumentBuilderFactory();
        DocumentBuilderFactory secureFactoryTwo = XMLSecureFactories.createWithConfig((Boolean)true, (Boolean)false).getDocumentBuilderFactory();
        Assert.assertThat((Object)insecureFactoryOne, (Matcher)CoreMatchers.sameInstance((Object)insecureFactoryTwo));
        Assert.assertThat((Object)secureFactoryOne, (Matcher)CoreMatchers.sameInstance((Object)secureFactoryTwo));
        Assert.assertThat((Object)insecureFactoryOne, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)secureFactoryOne)));
    }
}

