/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.transformers;

import de.odysseus.staxon.json.JsonXMLOutputFactory;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stax.StAXSource;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.module.json.transformers.AbstractToFromXmlTransformer;
import org.mule.module.json.transformers.TransformerInputs;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.IOUtils;
import org.mule.util.xmlsecurity.XMLSecureFactories;
import org.w3c.dom.Document;

public class XmlToJson
extends AbstractToFromXmlTransformer {
    public XmlToJson() {
        this.registerSourceType(DataTypeFactory.STRING);
        this.registerSourceType(DataTypeFactory.INPUT_STREAM);
        this.registerSourceType(DataTypeFactory.BYTE_ARRAY);
        this.registerSourceType(DataTypeFactory.create(Reader.class));
        this.registerSourceType(DataTypeFactory.create(URL.class));
        this.registerSourceType(DataTypeFactory.create(File.class));
        this.registerSourceType(DataTypeFactory.create(Document.class));
        this.setReturnDataType(DataTypeFactory.JSON_STRING);
    }

    protected Object doTransform(Object src, String enc) throws TransformerException {
        XMLInputFactory inputFactory = XMLSecureFactories.createDefault().getXMLInputFactory();
        inputFactory.setProperty("javax.xml.stream.isCoalescing", true);
        TransformerInputs inputs = null;
        try {
            Source source;
            if (src instanceof Document) {
                Document doc = (Document)src;
                String location = doc.getDocumentURI();
                if (location == null) {
                    location = "(Document)";
                }
                source = new DOMSource(doc, location);
            } else {
                inputs = new TransformerInputs((Transformer)this, src);
                source = inputs.getInputStream() != null ? new StAXSource(inputFactory.createXMLStreamReader(inputs.getInputStream(), enc == null ? "UTF-8" : enc)) : new StAXSource(inputFactory.createXMLStreamReader(inputs.getReader()));
            }
            JsonXMLOutputFactory outputFactory = new JsonXMLOutputFactory();
            outputFactory.setProperty("JsonXMLOutputFactory.autoArray", true);
            outputFactory.setProperty("JsonXMLOutputFactory.prettyPrint", true);
            String string = this.convert(source, (XMLOutputFactory)outputFactory);
            return string;
        }
        catch (Exception ex) {
            throw new TransformerException((Transformer)this, (Throwable)ex);
        }
        finally {
            if (inputs != null) {
                IOUtils.closeQuietly((InputStream)inputs.getInputStream());
                IOUtils.closeQuietly((Reader)inputs.getReader());
            }
        }
    }
}

