/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.quartz;

import java.util.Date;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.AbstractMessageDispatcher;
import org.mule.transport.NullPayload;
import org.mule.transport.quartz.QuartzConnector;
import org.mule.transport.quartz.config.JobConfig;
import org.mule.transport.quartz.i18n.QuartzMessages;
import org.mule.transport.quartz.jobs.CustomJob;
import org.mule.transport.quartz.jobs.CustomJobConfig;
import org.mule.transport.quartz.jobs.CustomJobFromMessageConfig;
import org.mule.transport.quartz.jobs.ScheduledDispatchJobConfig;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

public class QuartzMessageDispatcher
extends AbstractMessageDispatcher {
    public QuartzMessageDispatcher(OutboundEndpoint endpoint) {
        super(endpoint);
    }

    protected void doDispose() {
    }

    protected void doDispatch(MuleEvent event) throws Exception {
        CronTrigger trigger;
        JobConfig jobConfig = (JobConfig)this.endpoint.getProperty((Object)"jobConfig");
        if (jobConfig == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull((String)"jobConfig").getMessage());
        }
        JobDetail jobDetail = new JobDetail();
        jobDetail.setName(this.endpoint.getEndpointURI().getAddress() + "-" + event.getId());
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put((Object)"jobDynamic", (Object)Boolean.TRUE);
        MuleMessage msg = event.getMessage();
        for (String key : msg.getInvocationPropertyNames()) {
            jobDataMap.put((Object)key, msg.getInvocationProperty(key));
        }
        for (String key : msg.getOutboundPropertyNames()) {
            jobDataMap.put((Object)key, msg.getOutboundProperty(key));
        }
        if (jobConfig instanceof ScheduledDispatchJobConfig) {
            ScheduledDispatchJobConfig scheduledDispatchJobConfig = (ScheduledDispatchJobConfig)jobConfig;
            String endpointRef = event.getMuleContext().getExpressionManager().parse(scheduledDispatchJobConfig.getEndpointRef(), event);
            jobDataMap.put("endpointRef", endpointRef);
        }
        jobDetail.setJobDataMap(jobDataMap);
        Job job = null;
        Object payload = event.getMessage().getPayload();
        if (jobConfig instanceof CustomJobConfig) {
            job = ((CustomJobConfig)jobConfig).getJob();
        } else if (jobConfig instanceof CustomJobFromMessageConfig) {
            job = ((CustomJobFromMessageConfig)jobConfig).getJob(msg);
            jobConfig = ((CustomJobFromMessageConfig)jobConfig).getJobConfig(msg);
        }
        jobDataMap.put((Object)"jobConfig", (Object)jobConfig);
        jobDetail.setJobClass(jobConfig.getJobClass());
        if (job != null) {
            jobDataMap.put((Object)"jobObject", (Object)job);
            jobDetail.setJobClass(CustomJob.class);
        }
        jobDataMap.put((Object)"payload", payload);
        String cronExpression = jobDataMap.getString("cronExpression");
        String repeatInterval = jobDataMap.getString("repeatInterval");
        String repeatCount = jobDataMap.getString("repeatCount");
        String startDelay = jobDataMap.getString("startDelay");
        String groupName = jobConfig.getGroupName();
        String jobGroupName = jobConfig.getJobGroupName();
        if (groupName == null) {
            groupName = "mule";
        }
        if (jobGroupName == null) {
            jobGroupName = groupName;
        }
        jobDetail.setGroup(groupName);
        if (cronExpression != null) {
            CronTrigger ctrigger = new CronTrigger();
            ctrigger.setCronExpression(cronExpression);
            trigger = ctrigger;
        } else if (repeatInterval != null) {
            SimpleTrigger strigger = new SimpleTrigger();
            strigger.setRepeatInterval(Long.parseLong(repeatInterval));
            if (repeatCount != null) {
                strigger.setRepeatCount(Integer.parseInt(repeatCount));
            } else {
                strigger.setRepeatCount(-1);
            }
            trigger = strigger;
        } else {
            throw new IllegalArgumentException(QuartzMessages.cronExpressionOrIntervalMustBeSet().getMessage());
        }
        trigger.setName(this.endpoint.getEndpointURI().toString() + "-" + event.getId());
        trigger.setGroup(groupName);
        trigger.setJobName(jobDetail.getName());
        trigger.setJobGroup(jobGroupName);
        Scheduler scheduler = ((QuartzConnector)this.getConnector()).getQuartzScheduler();
        long start = System.currentTimeMillis();
        if (startDelay != null) {
            start += Long.parseLong(startDelay);
        }
        trigger.setStartTime(new Date(start));
        scheduler.scheduleJob(jobDetail, (Trigger)trigger);
    }

    protected MuleMessage doSend(MuleEvent event) throws Exception {
        this.doDispatch(event);
        return new DefaultMuleMessage((Object)NullPayload.getInstance(), this.connector.getMuleContext());
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }
}

