/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.email;

import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.mail.Address;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.transport.PropertyScope;
import org.mule.transport.AbstractMuleMessageFactory;
import org.mule.transport.email.MailUtils;
import org.mule.util.StringUtils;

public class MailMuleMessageFactory
extends AbstractMuleMessageFactory {
    public static final String HEADER_LIST_PREFIX = "List:";
    private static Log log = LogFactory.getLog(MailMuleMessageFactory.class);

    public MailMuleMessageFactory(MuleContext context) {
        super(context);
    }

    protected Class<?>[] getSupportedTransportMessageTypes() {
        return new Class[]{Message.class};
    }

    protected Object extractPayload(Object transportMessage, String encoding) throws Exception {
        return transportMessage;
    }

    protected void addProperties(DefaultMuleMessage muleMessage, Object transportMessage) throws Exception {
        super.addProperties(muleMessage, transportMessage);
        Message mailMessage = (Message)transportMessage;
        this.addRecipientProperty((MuleMessage)muleMessage, mailMessage, Message.RecipientType.TO, "toAddresses");
        this.addRecipientProperty((MuleMessage)muleMessage, mailMessage, Message.RecipientType.CC, "ccAddresses");
        this.addRecipientProperty((MuleMessage)muleMessage, mailMessage, Message.RecipientType.BCC, "bccAddresses");
        this.addReplyToProperty(muleMessage, mailMessage);
        this.addFromProperty(muleMessage, mailMessage);
        muleMessage.setInboundProperty("subject", (Object)StringUtils.defaultIfEmpty((String)mailMessage.getSubject(), (String)"(no subject)"));
        muleMessage.setInboundProperty("contentType", (Object)StringUtils.defaultIfEmpty((String)mailMessage.getContentType(), (String)"text/plain"));
        this.addSentDateProperty(muleMessage, mailMessage);
        this.addMailHeadersToMessageProperties(mailMessage, muleMessage);
    }

    protected void addRecipientProperty(MuleMessage muleMessage, Message mailMessage, Message.RecipientType recipientType, String property) throws MessagingException {
        block3: {
            MimeMessage mimeMessage = null;
            if (mailMessage instanceof MimeMessage) {
                mimeMessage = (MimeMessage)mailMessage;
            }
            try {
                Address[] recipients = mailMessage.getRecipients(recipientType);
                muleMessage.setProperty(property, (Object)MailUtils.mailAddressesToString(recipients), PropertyScope.INBOUND);
            }
            catch (MessagingException e) {
                if (mimeMessage == null) break block3;
                Object[] header = mimeMessage.getHeader(recipientType.toString());
                String recipients = StringUtils.join((Object[])header, (String)", ");
                muleMessage.setProperty(property, (Object)recipients, PropertyScope.INBOUND);
            }
        }
    }

    protected void addReplyToProperty(DefaultMuleMessage muleMessage, Message mailMessage) {
        try {
            muleMessage.setInboundProperty("replyToAddresses", (Object)MailUtils.mailAddressesToString(mailMessage.getReplyTo()));
        }
        catch (MessagingException me) {
            log.warn((Object)"Invalid address found in ReplyTo header:", (Throwable)me);
        }
    }

    protected void addFromProperty(DefaultMuleMessage muleMessage, Message mailMessage) {
        try {
            muleMessage.setInboundProperty("fromAddress", (Object)MailUtils.mailAddressesToString(mailMessage.getFrom()));
        }
        catch (MessagingException me) {
            log.warn((Object)"Invalid address found in From header:", (Throwable)me);
        }
    }

    protected void addSentDateProperty(DefaultMuleMessage muleMessage, Message mailMessage) throws MessagingException {
        Date sentDate = mailMessage.getSentDate();
        if (sentDate == null) {
            sentDate = new Date();
        }
        muleMessage.setInboundProperty("sentDate", (Object)sentDate);
    }

    protected void addMailHeadersToMessageProperties(Message mailMessage, DefaultMuleMessage muleMessage) throws MessagingException {
        Enumeration e = mailMessage.getAllHeaders();
        while (e.hasMoreElements()) {
            LinkedList listPropertyValue;
            Header header = (Header)e.nextElement();
            String name = header.getName();
            String listName = MailUtils.toListHeader(name);
            String value = header.getValue();
            if (null == muleMessage.getInboundProperty(name)) {
                muleMessage.setInboundProperty(name, (Object)value);
            }
            if (null == (listPropertyValue = muleMessage.getInboundProperty(listName))) {
                listPropertyValue = new LinkedList();
                muleMessage.setInboundProperty(listName, listPropertyValue);
            }
            if (!(listPropertyValue instanceof List)) continue;
            ((List)listPropertyValue).add(header.getValue());
        }
    }

    protected void addAttachments(DefaultMuleMessage muleMessage, Object transportMessage) throws Exception {
        super.addAttachments(muleMessage, transportMessage);
        Object content = ((Message)transportMessage).getContent();
        if (content instanceof Multipart) {
            Multipart multipart = (Multipart)content;
            TreeMap<String, Part> attachments = new TreeMap<String, Part>();
            MailUtils.getAttachments(multipart, attachments);
            log.debug((Object)"Received Multipart message. Adding attachments");
            for (Map.Entry<String, Part> entry : attachments.entrySet()) {
                Part part = entry.getValue();
                String name = entry.getKey();
                muleMessage.addInboundAttachment(name, part.getDataHandler());
                this.addAttachmentHeaders(name, part, (MuleMessage)muleMessage);
            }
        }
    }

    protected void addAttachmentHeaders(String name, Part part, MuleMessage muleMessage) throws MessagingException {
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration e = part.getAllHeaders();
        while (e.hasMoreElements()) {
            Header h = (Header)e.nextElement();
            headers.put(h.getName(), h.getValue());
        }
        if (headers.size() > 0) {
            muleMessage.setProperty(name + "Headers", headers, PropertyScope.INBOUND);
        }
    }
}

