/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jersey;

import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.api.MuleMessage;
import org.mule.module.jersey.JerseyResourcesComponent;

public class MuleResponseWriter
implements ContainerResponseWriter {
    private final MuleMessage message;
    private OutputStream outputStream;
    private boolean headersWritten = false;

    public MuleResponseWriter(MuleMessage request) {
        this.message = request;
    }

    public OutputStream writeStatusAndHeaders(long x, ContainerResponse response) throws IOException {
        if (!this.headersWritten) {
            HashMap customHeaders = new HashMap();
            for (Map.Entry e : response.getHttpHeaders().entrySet()) {
                this.message.setOutboundProperty((String)e.getKey(), (Object)this.getHeaderValue((List)e.getValue()));
            }
            this.message.setInvocationProperty(JerseyResourcesComponent.JERSEY_RESPONSE, (Object)response);
            this.message.setOutboundProperty("http.status", (Object)response.getStatus());
            this.headersWritten = true;
        }
        return this.outputStream;
    }

    private String getHeaderValue(List<Object> values) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Object o : values) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(ContainerResponse.getHeaderValue((Object)o));
        }
        return sb.toString();
    }

    public void finish() throws IOException {
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }
}

