/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.builder;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.builder.CompositeBuilder;
import org.jbpm.pvm.internal.builder.UnresolvedFlow;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;

public class ProcessDefinitionBuilder
extends CompositeBuilder {
    private static final Log log = Log.getLog((String)ProcessDefinitionBuilder.class.getName());
    protected ProcessDefinitionImpl processDefinition;
    protected List<UnresolvedFlow> unresolvedFlows = new ArrayList<UnresolvedFlow>();

    protected ProcessDefinitionBuilder(ProcessDefinitionImpl processDefinition) {
        this.processDefinition = processDefinition;
        this.compositeElement = processDefinition;
    }

    public static ProcessDefinitionBuilder startProcess() {
        return ProcessDefinitionBuilder.startProcess(null);
    }

    public static ProcessDefinitionBuilder startProcess(String processDefinitionName) {
        return ProcessDefinitionBuilder.startProcess(processDefinitionName, new ProcessDefinitionImpl());
    }

    public static ProcessDefinitionBuilder startProcess(String processDefinitionName, ProcessDefinitionImpl processDefinition) {
        processDefinition.setName(processDefinitionName);
        return new ProcessDefinitionBuilder(processDefinition);
    }

    public ProcessDefinitionImpl endProcess() {
        this.verifyInitial();
        this.resolveFlows();
        return this.processDefinition;
    }

    protected void verifyInitial() {
        if (this.processDefinition.getInitial() == null) {
            this.errorNoInitial();
        }
    }

    protected void resolveFlows() {
        for (UnresolvedFlow unresolvedFlow : this.unresolvedFlows) {
            ActivityImpl destination = this.processDefinition.findActivity(unresolvedFlow.destinationName);
            if (destination == null) {
                this.errorUnexistingFlowDestination(unresolvedFlow);
            }
            destination.addIncomingTransition(unresolvedFlow.transition);
        }
    }

    public ProcessDefinitionBuilder key(String key) {
        this.processDefinition.setKey(key);
        return this;
    }

    public ProcessDefinitionBuilder version(int version) {
        this.processDefinition.setVersion(version);
        return this;
    }

    public ProcessDefinitionBuilder description(String description) {
        this.processDefinition.setDescription(description);
        return this;
    }

    protected void addUnresolvedFlow(UnresolvedFlow unresolvedFlow) {
        this.unresolvedFlows.add(unresolvedFlow);
    }

    protected void setProcessDefinitionInitial(ActivityImpl initial) {
        if (this.processDefinition.getInitial() != null) {
            this.errorMultipleInitials(initial);
        }
        this.processDefinition.setInitial(initial);
    }

    protected void errorMultipleInitials(ActivityImpl initial) {
        log.error("multiple initial activities: " + this.processDefinition.getInitial() + " and " + initial);
    }

    protected void errorNoInitial() {
        log.error("no initial activity");
    }

    protected void errorUnexistingFlowDestination(UnresolvedFlow unresolvedFlow) {
        String sourceActivityName = unresolvedFlow.transition.getSource().getName();
        log.error("unexisting transition destination: " + sourceActivityName + "-->" + unresolvedFlow.destinationName);
    }
}

