/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.cmd;

import java.io.Serializable;
import java.util.HashSet;
import org.hibernate.Session;
import org.jbpm.api.JbpmException;
import org.jbpm.api.cmd.Environment;
import org.jbpm.pvm.internal.cmd.AbstractCommand;
import org.jbpm.pvm.internal.task.ParticipationImpl;
import org.jbpm.pvm.internal.task.TaskImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveParticipantCmd
extends AbstractCommand<Object> {
    private static final long serialVersionUID = 1L;
    protected Long taskDbid;
    protected Long swimlaneId;
    protected String userId;
    protected String groupId;
    protected String participationType;

    public RemoveParticipantCmd(String taskId, String swimlaneId, String userId, String groupId, String participationType) {
        this.swimlaneId = swimlaneId != null ? Long.valueOf(Long.parseLong(swimlaneId)) : null;
        this.taskDbid = taskId != null ? Long.valueOf(Long.parseLong(taskId)) : null;
        this.userId = userId;
        this.groupId = groupId;
        this.participationType = participationType;
    }

    public Object execute(Environment environment) throws Exception {
        Session session = (Session)environment.get(Session.class);
        if (this.taskDbid != null) {
            TaskImpl task = (TaskImpl)session.get(TaskImpl.class, (Serializable)this.taskDbid);
            if (task == null) {
                throw new JbpmException("task " + this.taskDbid + " was not found");
            }
            HashSet<ParticipationImpl> participations = new HashSet<ParticipationImpl>(task.getParticipations());
            for (ParticipationImpl participation : participations) {
                boolean groupMatch;
                boolean userMatch = this.userId != null ? this.userId.equals(participation.getUserId()) : false;
                boolean bl = groupMatch = this.groupId != null ? this.groupId.equals(participation.getGroupId()) : false;
                if (!userMatch && !groupMatch || !participation.getType().equals(this.participationType)) continue;
                task.removeParticipant(participation);
            }
        }
        return null;
    }
}

