/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.history.events;

import java.io.Serializable;
import org.hibernate.Session;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.history.HistoryEvent;
import org.jbpm.pvm.internal.history.model.HistoryActivityInstanceImpl;
import org.jbpm.pvm.internal.util.Clock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityEnd
extends HistoryEvent {
    private static final long serialVersionUID = 1L;
    protected String transitionName;

    public ActivityEnd() {
    }

    public ActivityEnd(String transitionName) {
        this.transitionName = transitionName;
    }

    @Override
    public void process() {
        Session session = EnvironmentImpl.getFromCurrent(Session.class);
        Long historyActivityInstanceDbId = this.execution.getHistoryActivityInstanceDbid();
        HistoryActivityInstanceImpl historyActivityInstance = (HistoryActivityInstanceImpl)session.load(this.getHistoryActivityInstanceClass(), (Serializable)historyActivityInstanceDbId);
        this.updateHistoryActivityInstance(historyActivityInstance);
        session.update((Object)historyActivityInstance);
    }

    protected void updateHistoryActivityInstance(HistoryActivityInstanceImpl historyActivityInstance) {
        historyActivityInstance.setEndTime(Clock.getTime());
        historyActivityInstance.setTransitionName(this.transitionName);
    }

    protected Class<? extends HistoryActivityInstanceImpl> getHistoryActivityInstanceClass() {
        return HistoryActivityInstanceImpl.class;
    }

    public String getTransitionName() {
        return this.transitionName;
    }
}

