/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.query;

import java.util.List;
import org.hibernate.Query;
import org.jbpm.api.JobQuery;
import org.jbpm.api.job.Job;
import org.jbpm.pvm.internal.job.JobImpl;
import org.jbpm.pvm.internal.job.MessageImpl;
import org.jbpm.pvm.internal.job.TimerImpl;
import org.jbpm.pvm.internal.query.AbstractQuery;
import org.jbpm.pvm.internal.query.Page;
import org.jbpm.pvm.internal.util.CollectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobQueryImpl
extends AbstractQuery
implements JobQuery {
    private static final long serialVersionUID = 1L;
    protected boolean messagesOnly = false;
    protected boolean timersOnly = false;
    protected String processInstanceId = null;
    protected Boolean exception;

    @Override
    public String hql() {
        StringBuilder hql = new StringBuilder();
        hql.append("select ");
        if (this.count) {
            hql.append("count(j) ");
        } else {
            hql.append("j ");
        }
        hql.append("from ");
        if (this.messagesOnly) {
            hql.append(MessageImpl.class.getName());
        } else if (this.timersOnly) {
            hql.append(TimerImpl.class.getName());
        } else {
            hql.append(JobImpl.class.getName());
        }
        hql.append(" j ");
        if (this.processInstanceId != null) {
            this.appendWhereClause("j.processInstance.id = '" + this.processInstanceId + "' ", hql);
        }
        if (this.exception != null) {
            if (this.exception.booleanValue()) {
                this.appendWhereClause("j.exception is not null ", hql);
            } else {
                this.appendWhereClause("j.exception is null ", hql);
            }
        }
        this.appendOrderByClause(hql);
        return hql.toString();
    }

    @Override
    protected void applyParameters(Query query) {
    }

    public List<Job> list() {
        return CollectionUtil.checkList(this.untypedList(), Job.class);
    }

    public Job uniqueResult() {
        return (Job)this.untypedUniqueResult();
    }

    public JobQuery messages() {
        this.messagesOnly = true;
        return this;
    }

    public JobQuery timers() {
        this.timersOnly = true;
        return this;
    }

    public JobQuery exception(boolean hasException) {
        this.exception = hasException;
        return this;
    }

    public JobQuery orderAsc(String property) {
        this.addOrderByClause("j." + property + " asc");
        return this;
    }

    public JobQuery orderDesc(String property) {
        this.addOrderByClause("j." + property + " desc");
        return this;
    }

    public JobQuery page(int firstResult, int maxResults) {
        this.page = new Page(firstResult, maxResults);
        return this;
    }

    public JobQuery processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }
}

