/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.query;

import java.util.List;
import org.hibernate.Query;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.ProcessInstanceQuery;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.query.AbstractQuery;
import org.jbpm.pvm.internal.query.Page;
import org.jbpm.pvm.internal.util.CollectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessInstanceQueryImpl
extends AbstractQuery
implements ProcessInstanceQuery {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;
    protected String processInstanceId;
    protected String processInstanceKey;
    protected Boolean suspended;

    public ProcessInstance uniqueResult() {
        return (ProcessInstance)this.untypedUniqueResult();
    }

    public List<ProcessInstance> list() {
        return CollectionUtil.checkList(this.untypedList(), ProcessInstance.class);
    }

    @Override
    public String hql() {
        StringBuilder hql = new StringBuilder();
        hql.append("select ");
        if (this.count) {
            hql.append("count(processInstance) ");
        } else {
            hql.append("processInstance ");
        }
        hql.append("from ");
        hql.append(ExecutionImpl.class.getName());
        hql.append(" as processInstance ");
        this.appendWhereClause("processInstance.parent is null ", hql);
        if (this.suspended != null) {
            if (this.suspended.booleanValue()) {
                this.appendWhereClause("processInstance.state = 'suspended' ", hql);
            } else {
                this.appendWhereClause("processInstance.state != 'suspended' ", hql);
            }
        }
        if (this.processInstanceId != null) {
            this.appendWhereClause("processInstance.processInstance.id = '" + this.processInstanceId + "' ", hql);
        }
        if (this.processDefinitionId != null) {
            this.appendWhereClause("processInstance.processDefinitionId = '" + this.processDefinitionId + "' ", hql);
        }
        if (this.processInstanceKey != null) {
            this.appendWhereClause("processInstance.key = '" + this.processInstanceKey + "'", hql);
        }
        this.appendOrderByClause(hql);
        return hql.toString();
    }

    @Override
    protected void applyParameters(Query query) {
    }

    public ProcessInstanceQuery orderAsc(String property) {
        this.addOrderByClause("processInstance." + property + " asc");
        return this;
    }

    public ProcessInstanceQuery orderDesc(String property) {
        this.addOrderByClause("processInstance." + property + " desc");
        return this;
    }

    public ProcessInstanceQuery page(int firstResult, int maxResults) {
        this.page = new Page(firstResult, maxResults);
        return this;
    }

    public ProcessInstanceQuery processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    public ProcessInstanceQuery processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    public ProcessInstanceQuery suspended() {
        this.suspended = true;
        return this;
    }

    public ProcessInstanceQuery processInstanceKey(String processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
        return this;
    }

    public ProcessInstanceQuery notSuspended() {
        this.suspended = false;
        return this;
    }
}

