/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.repository;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jbpm.pvm.internal.repository.DeploymentClassLoader;
import org.jbpm.pvm.internal.repository.RepositoryCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryCacheImpl
implements RepositoryCache {
    Map<String, Map<String, Object>> deployments = new HashMap<String, Map<String, Object>>();
    Map<Object, DeploymentClassLoader> deploymentClassLoaders = new HashMap<Object, DeploymentClassLoader>();

    @Override
    public Object get(String deploymentId, String objectName) {
        Map<String, Object> deploymentObjects = this.deployments.get(deploymentId);
        if (deploymentObjects == null) {
            return null;
        }
        return deploymentObjects.get(objectName);
    }

    @Override
    public void set(String deploymentId, String key, Object cachedObject) {
        HashMap<String, Object> objects = new HashMap<String, Object>();
        objects.put(key, cachedObject);
        this.set(deploymentId, objects);
    }

    @Override
    public void set(String deploymentId, Map<String, Object> objects) {
        if (objects == null) {
            this.deployments.put(deploymentId, null);
        } else {
            Map<String, Object> deploymentObjects = this.deployments.get(deploymentId);
            if (deploymentObjects == null) {
                deploymentObjects = new HashMap<String, Object>();
                this.deployments.put(deploymentId, deploymentObjects);
            }
            for (String objectName : objects.keySet()) {
                Object object = objects.get(objectName);
                deploymentObjects.put(objectName, object);
            }
        }
    }

    @Override
    public Set<String> getCachedDeploymentIds() {
        if (this.deployments != null) {
            return new HashSet<String>(this.deployments.keySet());
        }
        return Collections.emptySet();
    }

    @Override
    public void remove(String deploymentDbid) {
        if (this.deployments != null) {
            this.deployments.remove(deploymentDbid);
        }
    }

    @Override
    public void clear() {
        this.deployments = new HashMap<String, Map<String, Object>>();
    }

    @Override
    public DeploymentClassLoader getDeploymentClassLoader(String deploymentId, ClassLoader original) {
        Object key = this.getDeploymentClassLoaderKey(deploymentId, original);
        return this.deploymentClassLoaders.get(key);
    }

    @Override
    public void setDeploymentClassLoader(String deploymentId, ClassLoader original, DeploymentClassLoader deploymentClassLoader) {
        this.deploymentClassLoaders.put(this.getDeploymentClassLoaderKey(deploymentId, original), deploymentClassLoader);
    }

    protected Object getDeploymentClassLoaderKey(String deploymentId, ClassLoader original) {
        ArrayList<Object> key = new ArrayList<Object>();
        key.add(deploymentId);
        key.add(original);
        return key;
    }
}

