/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.tx;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.transaction.Synchronization;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.tx.AbstractTransaction;
import org.jbpm.pvm.internal.tx.StandardResource;
import org.jbpm.pvm.internal.tx.StandardSynchronization;
import org.jbpm.pvm.internal.tx.TransactionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardTransaction
extends AbstractTransaction
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Log log = Log.getLog((String)StandardTransaction.class.getName());
    protected List<StandardResource> resources;
    protected List<StandardSynchronization> synchronizations;
    protected State state = State.CREATED;

    public void begin() {
        if (log.isTraceEnabled()) {
            log.trace("beginning " + this);
        }
        this.state = State.ACTIVE;
    }

    public void complete() {
        if (this.state == State.ACTIVE) {
            this.commit();
        } else if (this.state == State.ROLLBACKONLY) {
            this.rollback();
        } else {
            throw new TransactionException("complete on transaction in state " + (Object)((Object)this.state));
        }
    }

    public void setRollbackOnly() {
        if (this.state != State.ACTIVE) {
            throw new TransactionException("transaction was not active: " + (Object)((Object)this.state));
        }
        this.state = State.ROLLBACKONLY;
    }

    public boolean isRollbackOnly() {
        return this.state == State.ROLLBACKONLY || this.state == State.ROLLEDBACK;
    }

    public void commit() {
        this.flushDeserializedObjects();
        if (this.state != State.ACTIVE) {
            throw new TransactionException("commit on transaction in state " + (Object)((Object)this.state));
        }
        log.trace("committing " + this);
        try {
            this.beforeCompletion();
            if (this.resources != null) {
                for (StandardResource standardResource : this.resources) {
                    if (log.isTraceEnabled()) {
                        log.trace("preparing resource " + standardResource);
                    }
                    standardResource.prepare();
                }
            }
        }
        catch (Exception exception) {
            try {
                if (log.isTraceEnabled()) {
                    log.trace("resource threw exception in prepare.  rolling back.");
                }
                this.rollbackResources();
            }
            catch (Exception rollbackException) {
                log.error("rollback failed as well", (Throwable)rollbackException);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new TransactionException("prepare failed", exception);
        }
        RuntimeException commitException = null;
        if (this.resources != null) {
            for (StandardResource standardResource : this.resources) {
                try {
                    if (log.isTraceEnabled()) {
                        log.trace("committing resource " + standardResource);
                    }
                    standardResource.commit();
                }
                catch (RuntimeException t) {
                    log.error("commit failed for resource " + standardResource, (Throwable)t);
                    if (commitException != null) continue;
                    commitException = t;
                }
            }
        }
        this.state = State.COMMITTED;
        this.afterCompletion();
        if (log.isTraceEnabled()) {
            log.trace("committed " + this);
        }
        if (commitException != null) {
            throw commitException;
        }
    }

    public void rollback() {
        if (this.state != State.ACTIVE && this.state != State.ROLLBACKONLY) {
            throw new TransactionException("rollback on transaction in state " + (Object)((Object)this.state));
        }
        if (log.isTraceEnabled()) {
            log.trace("rolling back " + this);
        }
        this.beforeCompletion();
        this.rollbackResources();
    }

    void rollbackResources() {
        if (this.resources != null) {
            for (StandardResource resource : this.resources) {
                try {
                    if (log.isTraceEnabled()) {
                        log.trace("rolling back resource " + resource);
                    }
                    resource.rollback();
                }
                catch (Exception e) {
                    log.error("rollback failed for resource " + resource);
                }
            }
        }
        this.state = State.ROLLEDBACK;
        this.afterCompletion();
        if (log.isTraceEnabled()) {
            log.trace("rolled back");
        }
    }

    @Override
    public void registerSynchronization(Synchronization synchronization) {
        if (this.synchronizations == null) {
            this.synchronizations = new ArrayList<StandardSynchronization>();
        }
        this.synchronizations.add(new StandardSynchronization(synchronization));
    }

    public void afterCompletion() {
        if (this.synchronizations != null) {
            for (StandardSynchronization synchronization : this.synchronizations) {
                synchronization.afterCompletion(this.state);
            }
        }
    }

    public void beforeCompletion() {
        if (this.synchronizations != null) {
            for (StandardSynchronization synchronization : this.synchronizations) {
                synchronization.beforeCompletion();
            }
        }
    }

    public void enlistResource(StandardResource standardResource) {
        if (this.resources == null) {
            this.resources = new ArrayList<StandardResource>();
        }
        log.trace("enlisting resource " + standardResource + " to standard transaction");
        this.resources.add(standardResource);
    }

    List<StandardResource> getResources() {
        return this.resources;
    }

    public String toString() {
        return "StandardTransaction[" + System.identityHashCode(this) + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        CREATED,
        ACTIVE,
        ROLLBACKONLY,
        COMMITTED,
        ROLLEDBACK;

    }
}

