/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.wire.binding;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.pvm.internal.util.ReflectUtil;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.wire.Descriptor;
import org.jbpm.pvm.internal.wire.binding.WireDescriptorBinding;
import org.jbpm.pvm.internal.wire.descriptor.CollectionDescriptor;
import org.jbpm.pvm.internal.xml.Parse;
import org.jbpm.pvm.internal.xml.Parser;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCollectionBinding
extends WireDescriptorBinding {
    public AbstractCollectionBinding(String tagName) {
        super(tagName);
    }

    @Override
    public Object parse(Element element, Parse parse, Parser parser) {
        Boolean isSynchronized;
        CollectionDescriptor descriptor = this.createDescriptor();
        String className = XmlUtil.attribute(element, "class");
        if (AbstractCollectionBinding.verify(className, this.getCollectionInterface(), parse, parser)) {
            descriptor.setClassName(className);
        }
        if ((isSynchronized = XmlUtil.attributeBoolean(element, "synchronized", parse)) != null) {
            descriptor.setSynchronized(isSynchronized);
        }
        ArrayList<Descriptor> valueDescriptors = new ArrayList<Descriptor>();
        List<Element> elements = XmlUtil.elements(element);
        for (Element valueElement : elements) {
            Descriptor valueDescriptor = (Descriptor)parser.parseElement(valueElement, parse, "descriptor");
            if (valueDescriptor != null) {
                valueDescriptors.add(valueDescriptor);
                continue;
            }
            parse.addProblem("unrecognized element: " + XmlUtil.toString(valueElement));
        }
        descriptor.setValueDescriptors(valueDescriptors);
        return descriptor;
    }

    public static boolean verify(String className, Class<?> collectionInterface, Parse parse, Parser parser) {
        if (className == null) {
            return false;
        }
        try {
            Class<?> collectionClass = ReflectUtil.classForName(className);
            if (collectionInterface.isAssignableFrom(collectionClass)) {
                return true;
            }
            parse.addProblem("class " + className + " is not a " + collectionInterface.getName());
        }
        catch (Exception e) {
            parse.addProblem("class " + className + " could not be found");
        }
        return false;
    }

    protected abstract Class<?> getCollectionInterface();

    protected abstract CollectionDescriptor createDescriptor();
}

