/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.wire.binding;

import org.jbpm.pvm.internal.email.impl.AddressTemplate;
import org.jbpm.pvm.internal.email.impl.AttachmentTemplate;
import org.jbpm.pvm.internal.email.impl.MailTemplate;
import org.jbpm.pvm.internal.email.impl.MailTemplateRegistry;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.wire.WireDefinition;
import org.jbpm.pvm.internal.wire.binding.WireDescriptorBinding;
import org.jbpm.pvm.internal.wire.descriptor.ProvidedObjectDescriptor;
import org.jbpm.pvm.internal.xml.Parse;
import org.jbpm.pvm.internal.xml.Parser;
import org.w3c.dom.Attr;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MailTemplateBinding
extends WireDescriptorBinding {
    public MailTemplateBinding() {
        super("mail-template");
    }

    public Object parse(Element element, Parse parse, Parser parser) {
        MailTemplateRegistry templateRegistry;
        ProvidedObjectDescriptor templateRegistryDescriptor;
        String templateRegistryName;
        WireDefinition wireDefinition = parse.contextStackFind(WireDefinition.class);
        if (wireDefinition != null && (templateRegistryName = wireDefinition.getDescriptorName(MailTemplateRegistry.class)) != null) {
            templateRegistryDescriptor = (ProvidedObjectDescriptor)wireDefinition.getDescriptor(templateRegistryName);
            templateRegistry = (MailTemplateRegistry)templateRegistryDescriptor.getProvidedObject();
        } else {
            templateRegistry = new MailTemplateRegistry();
            templateRegistryDescriptor = new ProvidedObjectDescriptor(templateRegistry, true);
        }
        MailTemplate mailTemplate = MailTemplateBinding.parseMailTemplate(element, parse);
        String templateName = XmlUtil.attribute(element, "name", parse);
        templateRegistry.addTemplate(templateName, mailTemplate);
        return templateRegistryDescriptor;
    }

    public static MailTemplate parseMailTemplate(Element element, Parse parse) {
        Element attachmentsElement;
        Element htmlElement;
        Element textElement;
        MailTemplate mailTemplate = new MailTemplate();
        mailTemplate.setLanguage(XmlUtil.attribute(element, "language"));
        mailTemplate.setFrom(MailTemplateBinding.parseRecipientTemplate(element, "from", parse));
        mailTemplate.setTo(MailTemplateBinding.parseRecipientTemplate(element, "to", parse));
        mailTemplate.setCc(MailTemplateBinding.parseRecipientTemplate(element, "cc", parse));
        mailTemplate.setBcc(MailTemplateBinding.parseRecipientTemplate(element, "bcc", parse));
        Element subjectElement = XmlUtil.element(element, "subject");
        if (subjectElement != null) {
            mailTemplate.setSubject(XmlUtil.getContentText(subjectElement));
        }
        if ((textElement = XmlUtil.element(element, "text")) != null) {
            mailTemplate.setText(XmlUtil.getContentText(textElement));
        }
        if ((htmlElement = XmlUtil.element(element, "html")) != null) {
            DocumentFragment fragment = htmlElement.getOwnerDocument().createDocumentFragment();
            Node child = htmlElement.getFirstChild();
            while (child != null) {
                Node next = child.getNextSibling();
                fragment.appendChild(child);
                child = next;
            }
            mailTemplate.setHtml(XmlUtil.toString(fragment));
        }
        if ((attachmentsElement = XmlUtil.element(element, "attachments")) != null) {
            for (Element attachmentElement : XmlUtil.elements(attachmentsElement, "attachment")) {
                AttachmentTemplate attachmentTemplate = new AttachmentTemplate();
                mailTemplate.addAttachmentTemplate(attachmentTemplate);
                attachmentTemplate.setName(XmlUtil.attribute(attachmentElement, "name"));
                attachmentTemplate.setDescription(XmlUtil.attribute(attachmentElement, "description"));
                Attr expressionAttr = attachmentElement.getAttributeNode("expression");
                if (expressionAttr != null) {
                    attachmentTemplate.setExpression(expressionAttr.getValue());
                    attachmentTemplate.setMimeType(XmlUtil.attribute(attachmentElement, "mime-type"));
                    continue;
                }
                Element expressionElem = XmlUtil.element(attachmentElement, "expression");
                if (expressionElem != null) {
                    attachmentTemplate.setExpression(XmlUtil.getContentText(expressionElem));
                    attachmentTemplate.setMimeType(XmlUtil.attribute(attachmentElement, "mime-type"));
                    continue;
                }
                Attr file = attachmentElement.getAttributeNode("file");
                if (file != null) {
                    attachmentTemplate.setFile(file.getValue());
                    continue;
                }
                Attr url = attachmentElement.getAttributeNode("url");
                if (url != null) {
                    attachmentTemplate.setUrl(url.getValue());
                    continue;
                }
                Attr resource = attachmentElement.getAttributeNode("resource");
                if (resource == null) continue;
                attachmentTemplate.setResource(resource.getValue());
            }
        }
        return mailTemplate;
    }

    private static AddressTemplate parseRecipientTemplate(Element element, String tagName, Parse parse) {
        Element recipientElement = XmlUtil.element(element, tagName);
        if (recipientElement == null) {
            return null;
        }
        String addresses = XmlUtil.attribute(recipientElement, "addresses");
        String users = XmlUtil.attribute(recipientElement, "users");
        String groups = XmlUtil.attribute(recipientElement, "groups");
        if (addresses == null && users == null && groups == null) {
            parse.addProblem(tagName + " does not specify any recipient", element);
        }
        AddressTemplate addressTemplate = new AddressTemplate();
        addressTemplate.setAddresses(addresses);
        addressTemplate.setUsers(users);
        addressTemplate.setGroups(groups);
        return addressTemplate;
    }
}

