/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jboss.transaction;

import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.jta.TransactionManager;
import com.arjuna.common.util.propertyservice.PropertiesFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.transaction.TransactionManagerFactory;
import org.springframework.util.StringUtils;

public class JBossArjunaTransactionManagerFactory
implements TransactionManagerFactory {
    public static final String PROPERTY_USER_DIR = "user.dir";
    public static final String PROPERTY_ENVIRONMENT_OBJECTSTORE_DIR = "ObjectStoreEnvironmentBean.objectStoreDir";
    public static final String PROPERTY_OBJECTSTORE_DIR = "com.arjuna.ats.arjuna.objectstore.objectStoreDir";
    public static final String PROPERTY_NODE_IDENTIFIER = "com.arjuna.ats.arjuna.nodeIdentifier";
    public static final String PROPERTY_DEFAULT_TIMEOUT = "com.arjuna.ats.arjuna.coordinator.defaultTimeout";
    public static final String PROPERTY_TX_REAPER_TIMEOUT = "com.arjuna.ats.arjuna.coordinator.txReaperTimeout";
    private Map<String, String> properties = new HashMap<String, String>();
    private javax.transaction.TransactionManager tm;

    public synchronized javax.transaction.TransactionManager create(MuleConfiguration config) throws Exception {
        if (this.tm == null) {
            String muleInternalDir = config.getWorkingDirectory();
            String objectStoreDir = this.properties.get(PROPERTY_OBJECTSTORE_DIR);
            if (StringUtils.isEmpty((Object)objectStoreDir)) {
                objectStoreDir = muleInternalDir + "/transaction-log";
            }
            arjPropertyManager.getObjectStoreEnvironmentBean().setObjectStoreDir(objectStoreDir);
            arjPropertyManager.getObjectStoreEnvironmentBean().setLocalOSRoot(muleInternalDir);
            Properties props = PropertiesFactory.getDefaultProperties();
            props.setProperty(PROPERTY_ENVIRONMENT_OBJECTSTORE_DIR, objectStoreDir);
            props.setProperty(PROPERTY_OBJECTSTORE_DIR, objectStoreDir);
            props.setProperty(PROPERTY_USER_DIR, muleInternalDir);
            if (!this.properties.containsKey(PROPERTY_NODE_IDENTIFIER)) {
                try {
                    InetAddress address = InetAddress.getLocalHost();
                    String xaNodeId = MessageFormat.format("Mule[{0}/{1}]", address.getHostName(), address.getHostAddress());
                    arjPropertyManager.getCoreEnvironmentBean().setNodeIdentifier(xaNodeId);
                }
                catch (UnknownHostException e) {
                    // empty catch block
                }
            }
            if (this.properties.containsKey(PROPERTY_DEFAULT_TIMEOUT)) {
                arjPropertyManager.getCoordinatorEnvironmentBean().setDefaultTimeout(Integer.valueOf(this.properties.get(PROPERTY_DEFAULT_TIMEOUT)).intValue());
            }
            if (this.properties.containsKey(PROPERTY_TX_REAPER_TIMEOUT)) {
                arjPropertyManager.getCoordinatorEnvironmentBean().setTxReaperTimeout(Long.valueOf(this.properties.get(PROPERTY_TX_REAPER_TIMEOUT)).longValue());
            }
            this.tm = TransactionManager.transactionManager();
        }
        return this.tm;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }
}

